SUBNNS_CODING_CIFAR10 = {
    #CIFAR10 (key= 'N_subNNs_per_class/N_subNNs')
    '1/1':['1' for cl in range(10)] ,
    '1/5':['10000', '10000', '01000', '01000', '00100', '00100', '00010', '00010', '00001', '00001'],
    '2/5':['11000', '10100', '10010', '10001', '01100', '01010', '01001', '00110', '00101', '00011'],
    '3/5':['00111', '01011', '01101', '01110', '10011', '10101', '10110', '11001', '11010', '11100'],
    '4/5':['01111', '01111', '10111', '10111', '11011', '11011', '11101', '11101', '11110', '11110'],
    '5/5':['11111' for cl in range(10)] ,
    '3/10':['1001001000', '0110001000', '1010000001', '0000001110', '0001010100', '0010100100', '0000110010', '0100010001', '0001100001', '1100000010'],
    '5/10':['1010100011', '0101010101', '1101100010', '0011001101', '1010010101', '1001001110', '1011101000', '0100011110', '0110111000', '0100110011'],
    '7/10':['0111100111', '1101101110', '0011111011', '1110110110', '1100111011', '1111001011', '1111011100', '0101111101', '1011010111', '1010111101'],
    '9/10':['0111111111', '1011111111', '1101111111', '1110111111', '1111011111', '1111101111', '1111110111', '1111111011', '1111111101', '1111111110'],
    '10/10':['1111111111' for cl in range(10)] ,
    '3/15':['000110000010000', '100000000000011', '010000000101000', '001100010000000', '100000001001000', '000010001000001', '000001000110000', '000001100000010', '011000000000100', '000000110000100'],
    '6/15':['011000001101100', '000110110100010', '010100100000111', '100101000011010', '111001000010100', '110010101000001', '000011010111000', '001011111000000', '001000010110011', '100100001001101'],
    '9/15':['011011100110110', '000100111111011', '111011110100001', '100110111100110', '110001011011110', '011100011011101', '111111011000100', '110100100101111', '101011001011011', '001111100111001'],
    '12/15':['010111110111111', '110110111110111', '111101011011111', '011111111111100', '111011011111110', '111100110111111', '111111111100011', '101111111011011', '111111101101101', '101011101111111'],
}



SUBNNS_CODING_CIFAR100 = {
    '1/1':['1' for cl in range(100)] ,
    '16/16': ['1'*16 for cl in range(100)] ,
    '20/20': ['1'*20 for cl in range(100)] ,
    #min Ham. dist = 2, r=0.7
    '7/10': ['1011001111', '1110110011', '0101111101', '0011111110', '1111011001', '1101100111', '1110011110', '1001111011', '1111110100', '0110101111', '1010111101', '1111101010', '0111010111', '1101011110', '0100111111', '1111100101', '0011111011', '1011010111', '1100111101', '1110001111', '0111111010', '1011111100', '1101101011', '1110110110', '1001110111', '0111101101', '1110011011', '1101011101', '0111110011', '1011101110', '1111101001', '0111011110', '1000111111', '1101110110', '0011111101', '1110100111', '1111010011', '1101001111', '1010111011', '0111111100', '1101111010', '1011011101', '0110110111', '0011101111', '1110111001', '1111001110', '0101110111', '1111010101', '1010111110', '0110011111', '1011100111', '1101111001', '1101101110', '1111110010', '1001011111', '1110101101', '0111011011', '1011101011', '1110111100', '1011110101', '0101101111', '1100110111', '1111011010', '0111110110', '1010011111', '0111111001', '1101101101', '1100111011', '1111000111', '0001111111', '1110101110', '1011110011', '0111011101', '1101111100', '0111101011', '1011011110', '1110110101', '0110111110', '1101011011', '1011111010', '0111100111', '1111001101', '1010110111', '1100011111', '1111110001', '1001101111', '0101111110', '1110101011', '1111010110', '1111101100', '0010111111', '1001111101', '0111001111', '1101110011', '0011110111', '1110111010', '1110011101', '1111100110', '0101011111', '1011111001'],
    
    #min Ham. dist = 2, r=0.5
    '5/10': ['0101011100', '1010100011', '0010111100', '1101000011', '0001111001', '1110000110', '1100011010', '0011100101', '0011110010', '1100001101', '1001101010', '0110010101', '1101100100', '0010011011', '0110101001', '1001010110', '1100110001', '0011001110', '1011001001', '0100110110', '1111010000', '0000101111', '0101000111', '1010111000', '1001010101', '0110101010', '0101111000', '1010000111', '1000011110', '0111100001', '0100011011', '1011100100', '0111001100', '1000110011', '0111010010', '1000101101', '1110001010', '0001110101', '1010011001', '0101100110', '0110110100', '1001001011', '0010010111', '1101101000', '0001011110', '1110100001', '1011110000', '0100001111', '0111000011', '1000111100', '0001110011', '1110001100', '0011001101', '1100110010', '0011101010', '1100010101', '1010100110', '0101011001', '1011010001', '0100101110', '1101010010', '0010101101', '1001011100', '0110100011', '0100110101', '1011001010', '0111011000', '1000100111', '0010110110', '1101001001', '0001101011', '1110010100', '1000011011', '0111100100', '0011010101', '1100101010', '0010011110', '1101100001', '0110010011', '1001101100', '0110111000', '1001000111', '0000111101', '1111000010', '1010101001', '0101010110', '0101001101', '1010110010', '0001111010', '1110000101', '0101110001', '1010001110', '0011000111', '1100111000', '0100100111', '1011011000', '1001110100', '0110001011', '1100010110', '0011101001'],
    
    #min Ham. dist = 2, r=0.75
    '9/12': ['010111111101', '101011110111', '111101011011', '111110101110', '011011111110', '110111110011', '101111001111', '111100111101', '111101100111', '101111111100', '011110011111', '110011111011', '111111010110', '100101111111', '111111101001', '011010111111', '101110111011', '111011011101', '011111100111', '110101111110', '110110110111', '111001101111', '011111111010', '101111011101', '110111001111', '001101111111', '111111110001', '111010111110', '011101111101', '111110101011', '100011111111', '111001110111', '110111011110', '001111101111', '111110010111', '111111111000', '110110111101', '101111110110', '011111011011', '111011101101', '111100111011', '111001011111', '010111110111', '101111101110', '101011111011', '111111010101', '110110101111', '011101111110', '101110111101', '110111011011', '111101110110', '011011101111', '011110110111', '111011011110', '101101111011', '110111101101', '000111111111', '111100011111', '111111100011', '111011111100', '111110111010', '110001111111', '001111011111', '111111100101', '111010110111', '111111001110', '011111111001', '110111110110', '101101101111', '101110011111', '011011111011', '110101111101', '101111110011', '011111101110', '110010111111', '111101011101', '110111101011', '011110111101', '111011010111', '101101111110', '111100101111', '010111011111', '101011111101', '111111110010', '011101110111', '101110111110', '111111001011', '110011111101', '111001111011', '100111110111', '011111111100', '111110001111', '110110111110', '111011100111', '111111011001', '111101110101', '001110111111', '010111111011', '101011011111', '111101101110'],
    
    #min Ham. dist = 2, r=0.2
    '3/15': ['010001000100000', '100100000010000', '001000100001000', '000000001000110', '000010010000001', '100001010000000', '000000000100011', '011000000010000', '000100101000000', '000010000001100', '000000110000010', '000011000010000', '010100000000001', '100000000100100', '001000001001000', '000001001000001', '001010000000010', '000000010101000', '010000100000100', '110010000000000', '000100010010000', '001101000000000', '000000100010001', '100000000001010', '000000001100100', '000010100100000', '001000010000100', '010000001010000', '000101000001000', '100000000000011', '000100000100010', '101000100000000', '010000000001001', '000001000010100', '000010011000000', '000100000000101', '000000000111000', '010001000000010', '100000101000000', '001010010000000', '001000000100001', '000011100000000', '110000010000000', '000000001010010', '000100000001100', '100110000000000', '001000000010001', '010000100100000', '000000011001000', '000001000000110', '000010000010100', '000100110000000', '100001000001000', '011000001000000', '000000100010010', '000000001100001', '010000000001010', '101000000000100', '000001010000001', '000110000100000', '000000100001001', '010000010000100', '001001000100000', '100000001010000', '000110000000010', '000000010110000', '000010000000101', '011100000000000', '000001101000000', '000010000011000', '101000000000010', '100000010100000', '000100001001000', '000000100000110', '010001000000001', '010010001000000', '000001010000010', '100000000001001', '000100100010000', '001000000100100', '100101000000000', '010010100000000', '000000010001010', '000000001000101', '001000000110000', '100010000000001', '000100011000000', '010000000001100', '001001100000000', '000000000110010', '001100000000001', '000000110000100', '000001000011000', '000010001000010', '110000000100000', '000001001100000', '010100000000010', '001010000001000', '100000000010100', '000000110000001'],
    
    #min Ham. dist = 4, r=0.4    
    '6/15': ['100111001000010', '010000100101101', '001000010111001', '011000101010100', '111010010001000', '000101110100010', '100110000010101', '001001011010010', '110000001100011', '000111100001100', '001111000100001', '100000110001110', '010011001110000', '000100001011110', '110101100000001', '101010011000001', '010000010111010', '001001101000101', '001110010000110', '110000100111000', '011101000001010', '100010111010000', '000100001101101', '010010110000011', '110001011000100', '101100000110010', '001011100101000', '010001000011101', '100100010110100', '001010101000011', '000100111001001', '000011000110110', '111100001001000', '100001010110001', '101001000001011', '010110100010010', '011000110100100', '000010001101110', '011100010010001', '100011101000100', '000011011001001', '111000000100110', '001101100011000', '000110011110000', '100110000101001', '010001101000110', '111000110000010', '000010100110101', '101000001011100', '010101010000011', '110010000001110', '000001111110000', '001100000100111', '010110001001001', '101110100000100', '110001110010000', '000001001011011', '001000111100010', '010101010001100', '101010000110001', '010010011100100', '100001100011010', '011100001100001', '001011010001100', '100100100100011', '000001010010111', '111010100010000', '100101101001000', '010010000011011', '001100011100100', '000110110011000', '000001001100111', '111011000100000', '100000011011010', '010100101110000', '011000000001111', '100111010000001', '001000100011101', '000100111000110', '001110001001010', '110001000110100', '000011110100001', '111000101000001', '011011000000110', '010110010000101', '100100001111000', '101001110100000', '000101000111010', '100010001000111', '011000110011000', '001010011010100', '010101100101000', '110000010010011', '100011000101100', '000011101010001', '101100011000010', '001000100101110', '010100000010111', '100000011101001', '011111100000000'],
    
    #min Ham. dist = 4, r=0.25
    '4/16': ['0010000110000100', '0100001001000010', '0001100000011000', '1000010000100001', '0001000100100010', '0010001000010001', '1100000000001100', '0000110011000000', '0110000001100000', '0000000010010110', '1001011000000000', '0000100100001001', '0101000000000101', '0000101010100000', '1010000000001010', '0000010101010000', '1000100001000100', '0100010010001000', '0000001100110000', '0011000000000011', '1001000010010000', '0000011000000110', '0110100100000000', '0000000001101001', '0100100000010010', '0001001001001000', '1000000110000001', '0010010000100100', '0101000010100000', '1000000101000010', '0000101000000101', '0010010000011000', '0000000011000011', '1100000000110000', '0000001100001100', '0011110000000000', '0001000101000100', '0100010000010001', '0010001010001000', '1000100000100010', '1010000001010000', '0000010100001010', '0000000010100101', '0101101000000000', '0000000000111100', '1100001100000000', '0010100001000001', '0001010010000010', '0110000000000110', '0001000100010001', '1000100010001000', '0000011001100000', '0100010001000100', '0000100110010000', '1001000000001001', '0010001000100010', '0100000100101000', '0011000011000000', '1000001000010100', '0000110000000011', '0000000001011010', '0001100000100100', '1010010100000000', '0100001010000001', '1010000010100000', '0000011000001001', '0000100100000110', '0101000001010000', '0000001111000000', '1100000000000011', '0011000000001100', '0000110000110000', '0101010100000000', '1010101000000000', '0000000010101010', '0000000001010101', '1000010010000100', '0001001000010010', '0010000100100001', '0100100001001000', '1001000001100000', '0110000010010000', '0000010100000101', '0000101000001010', '0001100010000001', '0010001001000100', '1000000100011000', '0100010000100010', '0000011010010000', '0110000000001001', '1001000000000110', '0000100101100000', '1000001001000001', '0100000110000010', '0001010000101000', '0010100000010100', '1100110000000000', '0011001100000000', '0000000000110011', '0000000011001100'],
    
    #min Ham. dist = 4, r=0.5
    '8/16': ['0110011011110000', '1001100100001111', '0010001001110111', '1101110110001000', '1010000010101111', '0101111101010000', '0101001100110101', '1010110011001010', '1100101010100011', '0011010101011100', '0011110001101001', '1100001110010110', '0111010010001011', '1000101101110100', '0000111110011001', '1111000001100110', '0110001111001001', '1001110000110110', '1010111110100000', '0101000001011111', '1011001011010100', '0100110100101011', '0101011001101010', '1010100110010101', '0010101110001110', '1101010001110001', '0011111100000011', '1100000011111100', '0110110010011100', '1001001101100011', '0001110111100010', '1110001000011101', '1010010100110011', '0101101011001100', '1000000111011011', '0111111000100100', '0001100010111101', '1110011101000010', '1111010100000101', '0000101011111010', '0110100101011010', '1001011010100101', '0000010111110101', '1111101000001010', '0111000110110010', '1000111001001101', '1000011100011110', '0111100011100001', '0110001101101100', '1001110010010011', '0011010110101100', '1100101001010011', '1100100111000110', '0011011000111001', '0100110100010111', '1011001011101000', '1100100100111001', '0011011011000110', '1111001100110000', '0000110011001111', '1010100101101010', '0101011010010101', '0010101101110001', '1101010010001110', '0101100101100101', '1010011010011010', '1011100001000111', '0100011110111000', '0100001011100111', '1011110100011000', '0101010111000011', '1010101000111100', '1110111000010001', '0001000111101110', '0010010001111110', '1101101110000001', '1110100010110010', '0001011101001101', '0011100100110110', '1100011011001001', '0000111101100110', '1111000010011001', '0011001101011010', '1100110010100101', '1110000111100001', '0001111000011110', '1001101001011001', '0110010110100110', '1001100111110000', '0110011000001111', '1100110001011010', '0011001110100101', '1101001011010010', '0010110100101101', '0011100111001001', '1100011000110110', '0101100110011010', '1010011001100101', '0110101010101001', '1001010101010110'],
    
    #min Ham. dist = 4, r=0.75
    '12/16': ['1011101110111011', '0101111101011111', '1111110011111100', '1110011111100111', '1011111011010111', '0110100111111111', '1111111101101001', '1101011110111110', '1011101111101110', '0111011111011101', '1111110000111111', '1100111111110011', '1011011101111011', '0101111110101111', '1111101011110101', '1110110111011110', '0111111011011011', '1011110111100111', '1101101101111110', '1110011110111101', '1111001111001111', '0011111111111100', '1101110101110111', '1110111010111011', '1111111110010110', '1001011011111111', '1110101101111101', '0111110111101011', '1010111101011111', '0111101110110111', '1101111011101101', '1111010111111010', '0111011101110111', '1101110111011101', '1110111011101110', '1111111100001111', '1111000011111111', '1001111111111001', '0110111111110110', '1011110110111101', '1101101111011011', '0111111001111110', '1010111110101111', '1111001111110011', '0000111111111111', '1111111111110000', '1111011010011111', '1111100101101111', '0111011111101110', '1010101011111111', '1111111100110011', '1011110111011011', '1101101110111101', '1111111111001100', '0101010111111111', '1110111001110111', '0110111111111001', '1001111111110110', '1111100110011111', '1111011001101111', '1111101011111010', '0011111100111111', '1100111111001111', '1111010111110101', '0111111011100111', '1110011101111110', '1011101111011101', '1101110110111011', '1111111100111100', '1110011111011011', '0101101011111111', '1110110111101101', '1011011110110111', '1011111011101011', '0111110111010111', '1101101111100111', '1011110101111110', '1110101110111110', '1101011101111101', '1101111011011110', '0111101101111011', '0111111010111101', '1010010111111111', '1111111111000011', '1111111110101010', '1100110011111111', '0011001111111111', '1111111101010101', '1111011011111001', '1001111101101111', '1111100111110110', '0110111110011111', '1111101001011111', '1111010110101111', '1010111111110101', '0101111111111010', '1110110101111011', '1101111010110111', '1011011111011110', '0111101111101101'],
    
    #min Ham. dist = 2, r=0.1
    '2/20': ['00001000000100000000', '10000000000000000100', '00000110000000000000', '00000000000001010000', '00010001000000000000', '01000000001000000000', '00100000000000001000', '00000000000000100010', '00000000000010000001', '00000000110000000000', '10000000000001000000', '00000000000000000101', '00000000000100000010', '01000010000000000000', '00000001000000001000', '00000000000000110000', '00100100000000000000', '00001000000010000000', '00010000010000000000', '00000000101000000000', '01010000000000000000', '00001010000000000000', '00000000000001000010', '00000000000010000100', '00000000000100010000', '00100001000000000000', '00000100010000000000', '10000000000000000001', '00000000100000001000', '00000000001000100000', '00001000000000001000', '01000000000000000010', '00000010000100000000', '00000001000000000100', '00000100100000000000', '00100000001000000000', '00000000000000100001', '10000000000000010000', '00000000010010000000', '00010000000001000000', '00010000000000001000', '10000001000000000000', '00001000000000000100', '00000000100000000010', '01000000000001000000', '00000000000110000000', '00100000010000000000', '00000010000000000001', '00000100001000000000', '00000000000000100100', '00000001000000010000', '10000000000100000000', '00101000000000000000', '00000000100001000000', '01000000000000001000', '00010000000000100000', '00000000001000000010', '00000100000000000001', '00000000010000010000', '00000010000010000000', '00010000000000000100', '00000000000100001000', '10000100000000000000', '00000000000001100000', '01001000000000000000', '00000000000010000010', '00000001100000000000', '00100000000000010000', '00000000001000000001', '00000010010000000000', '00000000000001000100', '00000000000000011000', '00000000100100000000', '00100000000000100000', '10001000000000000000', '01000000010000000000', '00000011000000000000', '00010000000000000010', '00000100000010000000', '00000000001000000100', '00001000000000000001', '00000100000100000000', '00100000000001000000', '00000010000000001000', '11000000000000000000', '00000000100000010000', '00000000000010100000', '00000000011000000000', '00010000000000000001', '00000001000000000010', '00000000010000000100', '00010000000100000000', '00001000000000100000', '00000100000001000000', '00000000001000001000', '00100000000000000001', '10000010000000000000', '01000001000000000000', '00000000100010000000', '00000000000000010010'],
    
    #min Ham. dist = 4, r=0.2
    '4/20': ['00000100100000010010', '11000000001100000000', '00001010000010100000', '00110000000000001100', '00000001010001000001', '00000000100100001001', '10100000000001010000', '00000110011000000000', '00001001000000000110', '01010000000010100000', '00001000001001000001', '00000010000100010010', '11000000110000000000', '00000101000010100000', '00000000000010011001', '10010110000000000000', '01100000000000000110', '00000000100101100000', '00001001011000000000', '00000000101000001010', '01010000000001010000', '10100000000000000101', '00000010010000100100', '00111100000000000000', '00000001000110001000', '00000100000100010100', '11000011000000000000', '00000000110011000000', '00110000000000000011', '00001000001000101000', '00000010001001000100', '00001000010000010010', '00000100100000100001', '11110000000000000000', '00001000000101000010', '00000010001000010001', '00000001100000100100', '00000100010010001000', '00110000001100000000', '00000010100010000010', '00000000010100000101', '10011001000000000000', '00000101000001010000', '10100000000010100000', '01010000000000001010', '01100000000000001001', '00000000000011001100', '11001100000000000000', '00000000001100110000', '00000011110000000000', '00001000100000010001', '00000100001001000010', '10100000010100000000', '00000011000000001100', '00000000011010010000', '01100000000001100000', '10010000100100000000', '00000110000000001001', '00000100010000100010', '00001000000110000001', '00000001001010000100', '01011010000000000000', '00000000000000111100', '00000001100001000010', '00001000010001001000', '11000000000000000011', '00110011000000000000', '01100000000010010000', '00000100001000100100', '00000001000100100010', '10100000101000000000', '10010000000010010000', '00000010000101001000', '01010000000000000101', '00001100110000000000', '10010000000001100000', '00000001100000011000', '00000100000110000010', '01100000011000000000', '00001010000000000101', '00000001001000100001', '10100000000000001010', '00000100100010000100', '01010000010100000000', '00001010000001010000', '00000000000011000011', '01100110000000000000', '00000001010000010100', '01010000101000000000', '00000010100000101000', '00001000001010000010', '00001000000100100100', '10100101000000000000', '10010000000000001001', '00000000010101010000', '00000000000000110011', '00110000110000000000', '00000011001100000000', '00001100000000001100', '11000000000011000000'],

    #min Ham. dist = 8, r=0.4 #a,b,c are permutation of the '8/20'
    '8/20': ['10100000010110010011', '01010000101001101100', '00001111000000001111', '00110110010100110000', '11001001101011000000', '01010000010110011100', '10100000101001100011', '00001111111100000000', '00111100000001101010', '11000011000010010101', '11000000001110100110', '00110000110001011001', '11111111000000000000', '00000011110000111100', '00001100001111000011', '01011100100101010000', '10100011011010100000', '11110000000000001111', '00000101101010100101', '00001010010101011010', '10011100010100000110', '01100011101000001001', '00001111000011110000', '10010000100111001010', '01100000011000110101', '10010110000001011100', '01101001000010100011', '11110000111100000000', '00000110011010011001', '00001001100101100110', '01100011010100000110', '10011100101000001001', '11110000000011110000', '00001001011001101001', '00000110100110010110', '01010011011001010000', '10101100100110100000', '00000000000011111111', '10010011101000000110', '01101100010100001001', '00110110101011000000', '11001001010100110000', '00000000111100001111', '11001100000001100101', '00110011000010011010', '11000110010111000000', '00111001101000110000', '01100000011011001010', '10010000100100110101', '01011001110000000101', '10100110001100001010', '10100101000011000110', '01011010000000111001', '00000011110011000011', '00001100001100111100', '10010101001110010000', '01101010110001100000', '10100000101010011100', '01010000010101100011', '00110101100100001100', '11001010011000000011', '10010110000010100011', '01101001000001011100', '00001100110011001100', '00000011001100110011', '10010000011000111010', '01100000100111000101', '10010011010100001001', '01101100101000000110', '00110011000001100101', '11001100000010011010', '00000000111111110000', '10101001110000001010', '01010110001100000101', '10011001000010101100', '01100110000001010011', '11000110101000110000', '00111001010111000000', '00001010010110100101', '00000101101001011010', '00110000001101010110', '11000000110010101001', '00110101011000000011', '11001010100100001100', '10011001000001010011', '01100110000010101100', '10011010110010010000', '01100101001101100000', '00000110100101101001', '00001001011010010110', '10100000010101101100', '01010000101010010011', '10100101000000111001', '01011010000011000110', '10101100011001010000', '01010011100110100000', '10101001001100000101', '01010110110000001010', '00000101010101010101', '00001010101010101010'],
     
    #min Ham. dist = 8, r=0.6
    '12/20':['01011111101001101100', '10101111010110010011', '11110000111111110000', '11001001101011001111', '00110110010100111111', '10101111101001100011', '01011111010110011100', '11110000000011111111', '11000011111110010101', '00111100111101101010', '00111111110001011001', '11001111001110100110', '00000000111111111111', '11111100001111000011', '11110011110000111100', '10100011011010101111', '01011100100101011111', '00001111111111110000', '11111010010101011010', '11110101101010100101', '01100011101011111001', '10011100010111110110', '11110000111100001111', '01101111011000110101', '10011111100111001010', '01101001111110100011', '10010110111101011100', '00001111000011111111', '11111001100101100110', '11110110011010011001', '10011100101011111001', '01100011010111110110', '00001111111100001111', '11110110100110010110', '11111001011001101001', '10101100100110101111', '01010011011001011111', '11111111111100000000', '01101100010111111001', '10010011101011110110', '11001001010100111111', '00110110101011001111', '11111111000011110000', '00110011111110011010', '11001100111101100101', '00111001101000111111', '11000110010111001111', '10011111100100110101', '01101111011011001010', '10100110001111111010', '01011001110011110101', '01011010111100111001', '10100101111111000110', '11111100001100111100', '11110011110011000011', '01101010110001101111', '10010101001110011111', '01011111010101100011', '10101111101010011100', '11001010011011110011', '00110101100111111100', '01101001111101011100', '10010110111110100011', '11110011001100110011', '11111100110011001100', '01101111100111000101', '10011111011000111010', '01101100101011110110', '10010011010111111001', '11001100111110011010', '00110011111101100101', '11111111000000001111', '01010110001111110101', '10101001110011111010', '01100110111101010011', '10011001111110101100', '00111001010111001111', '11000110101000111111', '11110101101001011010', '11111010010110100101', '11001111110010101001', '00111111001101010110', '11001010100111111100', '00110101011011110011', '01100110111110101100', '10011001111101010011', '01100101001101101111', '10011010110010011111', '11111001011010010110', '11110110100101101001', '01011111101010010011', '10101111010101101100', '01011010111111000110', '10100101111100111001', '01010011100110101111', '10101100011001011111', '01010110110011111010', '10101001001111110101', '11111010101010101010', '11110101010101010101'],
     
    #min Ham. dist = 4, r=0.8
    '16/20': ['11101011111010111111', '10110111101101111111', '11011110110111101111', '11111111111111110000', '01111101011111011111', '11110101111110101111', '10101111010111111111', '11011011101111011111', '01111110111001111111', '11111111001100111111', '10110111111011011111', '11111010111111110101', '01011111111111111010', '11101101110111101111', '11111111011011111001', '11111111111110010110', '10011001111111111111', '01100110111111111111', '11111111100111111001', '11111111111101100110', '11110011111111111100', '11001111111111110011', '00111111111111001111', '11111100001111111111', '11111111110000111111', '01111011011110111111', '11010111110101111111', '10101111101011111111', '11111100111111110011', '11111111111111001100', '11111010111101011111', '11011101111011101111', '11111111100111110110', '01101111111111111001', '10110111011110111111', '11101011101111101111', '01111101110101111111', '11011110011110111111', '11101110110111011111', '11110101111111111010', '01011111101011111111', '11111111011011110110', '11111111111101101001', '00111111111111111100', '11110011110011111111', '10111110101111101111', '11001111111100111111', '11110101111111110101', '11010111011111011111', '11101101111011011111', '10111011011101111111', '11111111100110011111', '00111111111111110011', '11111010111111111010', '11111111111110100101', '01111011110111101111', '10111110111010111111', '11001111111111111100', '11111111001111110011', '11110101111101011111', '11100111011111101111', '10111101110110111111', '11111111111101010101', '11111111101011111010', '01011010111111111111', '01110111101110111111', '11111111011001101111', '10011111111111110110', '11111001111111111001', '11101101101101111111', '11111111010111110101', '11011110111011011111', '11111111111110101010', '10111011110111011111', '01110111111011101111', '11101110011101111111', '11111111111110011001', '11110110100111111111', '01101111111111110110', '11110011111111110011', '11111100111111111100', '10011111111101101111', '11111001011011111111', '01101111111110011111', '10011111100111111111', '11111111010111111010', '01111011101101111111', '10101111111111110101', '11010111111010111111', '11111100111111001111', '11111111001111001111', '11111111110011111100', '11000011111111111111', '11111111111100110011', '00111100111111111111', '01011111010111111111', '11111010111110101111', '11111111101011110101', '11111111111101011010', '10100101111111111111'],
    

    #min Ham. dist = 2, r=0.05
    '2/40':['0000000000000000000000000000010000100000', '0000000000000000000010000000001000000000', '0000000001000001000000000000000000000000', '0000000000010000000000000000000010000000', '0000100000100000000000000000000000000000', '0000000000000000000000010000000100000000', '0000001000000000000000000000000000001000', '0000000000000000000000000100100000000000', '0000000000000000110000000000000000000000', '0100000000000000000000100000000000000000', '0000000000000000000100000000000000010000', '0001000000000100000000000000000000000000', '0000000000000010000000000000000000000010', '0000000000000000000000001001000000000000', '1000000000000000000001000000000000000000', '0000000010000000000000000000000000000001', '0000000000000000001000000000000001000000', '0000010100000000000000000000000000000000', '0010000000000000000000000000000000000100', '0000000000001000000000000010000000000000', '0000000000000000000000001000010000000000', '0000000000001000000000000000000100000000', '0000000000000000000000000000000001001000', '0010000000000000000000010000000000000000', '0000000000000000000010000000000000010000', '0000001000000000000000100000000000000000', '0000000100000000000000000000100000000000', '0000010000000000000000000000001000000000', '0000000000000000100000000100000000000000', '0000000000010000000000000000000000000100', '0000000000100000000000000010000000000000', '0000000000000100000001000000000000000000', '0100000000000000000000000000000000000010', '0000000000000000000100000000000000000001', '0000000000000000001000000001000000000000', '0000000010000000010000000000000000000000', '0001000000000010000000000000000000000000', '1000000000000000000000000000000010000000', '0000000000000001000000000000000000100000', '0000100001000000000000000000000000000000', '0100000000000000000000010000000000000000', '0000001000000000100000000000000000000000', '0000010000100000000000000000000000000000', '0000000000000000000010000000000000000100', '0000000000000000000000000000000000110000', '0000000000000010000000000000010000000000', '0000000000000000000000000010001000000000', '0000000000001000000000100000000000000000', '0000000001000000000000001000000000000000', '0011000000000000000000000000000000000000', '0000000000000000000001000000000000001000', '0000000100010000000000000000000000000000', '0000000000000100000000000000000100000000', '0000000000000000000000000000000011000000', '0000000000000000000000000000000000000011', 
            '0000000000000000010000000001000000000000', '0000100000000000000000000000100000000000', '0000000010000000001000000000000000000000', '1000000000000000000100000000000000000000', '0000000000000001000000000100000000000000', '0000000000000000000010000001000000000000', '0000001000000000000000000000100000000000', '0000010000000000000000000000000000100000', '0000000000000000000000001000001000000000', '0100000000000000000000000000000000010000', '0000000000010000000000100000000000000000', '0001000100000000000000000000000000000000', '0010000000000000100000000000000000000000', '0000000000000000001000010000000000000000', '0000000010000000000000000000010000000000', '0000000000100100000000000000000000000000', '0000000000000010000000000000000000001000', '1000000000000000000000000010000000000000', '0000000000000000000001000000000000000100', '0000000000000000000000000000000100000010', '0000000000001000000100000000000000000000', '0000000000000001000000000000000001000000', '0000100000000000000000000000000000000001', '0000000000000000010000000000000010000000', '0000000001000000000000000100000000000000', '0000100000000000000010000000000000000000', '0010000000000000000000000000000000100000', '0000010001000000000000000000000000000000', '0000001000000000000000000000000010000000', '0000000000000000000000001000000000000001', '1000000000000000100000000000000000000000', '0000000000000000000000000000010100000000', '0000000000000000000000000000100000001000', '0000000000100000000000000001000000000000', '0001000000000000000000010000000000000000', '0000000000000000000000100010000000000000', '0000000000000100000100000000000000000000', '0000000000000001000001000000000000000000', '0000000010000000000000000000001000000000', '0000000000000000001000000000000000000100', '0000000000010000000000000000000000010000', '0000000000001010000000000000000000000000', '0000000100000000000000000100000000000000', '0100000000000000010000000000000000000000', '0000000000000000000000000000000001000010'],

}


SUBNNS_CODING_IMAGENET={
    '1/1': ['1' for cl in range(1000)],
    '32/32':['1'*32 for cl in range(1000)],

    #min Hamming dist=6, r=0.75, min column sum  749 and max  751, avgHammingDist=12.01
    '24/32':['00000000111111111111111111111111', '11111111000011011111110111111010', '11111111111100111111001110100101', '00001111011111101101110111111111', '11101111111111110010111001011011', '00010111011110110110111111111111', '11110000100111111111111011111011', '11111000101011011011111111101111', '11111111110000010101111011111111', '11111111111101101000111111100101', '00001111101111110111011111110111', '11110000111111101011110101111111', '11111111111100011111101110001110', '11111111010111101111100001011111', '01111101111110111111011010111100', '10000111011101111111111111110110', '11111010100011111101111101011111', '11111111111011001100001111011111', '00111011111111110110111110111001', '11000101001111111101111011111111', '11111110110001101111101111110101', '11111111111110011011110110010101', '10111111101111111011011101101010', '01000111011111011111111101111101', '11111000111101110111110110101111', '11111011011111111100001111111010', '00001111110101111011101111111111', '11110100101111101111111111010110', '11111111110010011110101101111101', '11111111111010111010111001110110', '00010111101111101011111011111111', '11101000011101111101111101111111', '11111111110010101101111111101001', '01110111111111110111000110101111', '10001011101011111111111101111011', '11111110111110110110010110011111', '11111101010101101110011111110111', '11111111111111010101111010100011', '11111111111111010111100110011010', '00010111110111111111111101110011', '11101001011110110111011011111111', '11111110101101001111110011101111', '10111111111011111011101101011100', '01000111110111111110111110111110', '11111000011111001111011111011111', '11111111101001110011101110110111', '10110101111011111101110111101101', '01001011011110111111111110101111', '11111110100111110111011111001110', '11111111111100111100010111110011', '00101111111111111011110011111100', '11010001011111111111111111010011', '11111110100100111110111110111110', '11111111111011011010110111001011', '11111110110111101101101001111101', '00010111111011011111011110111111', '11101001011111101011111111100111', '11111111101100110111010011111110', '00111111111110111101101100111101', '11000011101111100111111111111110', '11111100011011110010111111110111', '11111111111101011001100101101111', '01011101101111111111111011011001', '10100011110111111101011111111110', '11111110010010111111011010111111', '11111111111101010111101001011101', '00111101011111101110111011111011',
             '11000110101111111110111101110111', '11111011110001101110110110111111', '11111111111110100101101101010111', '01101111111101011011111111101001', '10010011111111111110100111101111', '11111100001110110111111101111101', '11111111110011101011011011011110', '00111101111101011101011111111011', '11000110011011111011111110111111', '11111011100110110111011100111111', '11111111111111101110101111000100', '11011101111110011001110111111011', '00101110110111111111111111001101', '11110011001011001111111101111111', '11111111111101110001111010011110', '01011011111111111111100011110011', '10100101010010111111111111111111', '11111110101101101001111111111010', '11111111111111111111000101001001', '11111111111111010100011110110110', '00011011111011111011111111010111', '11100100111101011110101111111111', '11111111111111111101110010101000', '11111111000111111110001011111101', '00011011111100111111011111111101', '11100101101111111111110101001111', '11111111111010000111111101100111', '11111110010111111000111011111011', '00011101101111111100111111101111', '11100011011111111111001111110101', '11111110111101110011110101110011', '00111110111111001110111110111110', '11000101110101111111111111011101', '11111011001110111001011111011111', '11111111111110100111110011110010', '11011011111011001111101110101111', '00101101111011101111111111110101', '11110110001111011011100111111111', '11111111111011111111010000011011', '00111111010101110111111101111110', '11000101111011111111110111111010', '11111010101111001101111110111101', '11111111110110111011001101100111', '01101101110111110100111011111111', '10010110101111111101110111011111', '11111011011001110110111011111011', '11111111110101001011101110111101', '00111110111110111111110101101110', '11000111110111111011011011101111', '11111001101101111101101011111110', '11111111011010001111111111011100', '10111101100111110110111110110111', '01001110111011011111101011111111', '11110011011100111111110110011111', '11111111111111001101111101110000', '01111001110111110110011111101111', '10001110101110101111111111111101', '11110111011001110101111111001111', '11111111111111011111011011000010', '11111101111111110010101100111101', '00011110001001111111111111111111', '11100011111110010111110111101111', '11111111110111111000110000111111', '11111011111001111111001111010011', '00101111111110100011111111101111', '11010100110111111101101110111111', '11111111101111001110011010111011', 
             '00111101111111111001111101110110', '11000110111111110111001111011111', '11111011000101011111011111101111', '11111111011110111111101010110001', '10111111101111011100110101111110', '01001101111111111111100100111111', '11110010110111110011111111011101', '11111111011000111011111101101011', '01011111101111101110111011110110', '10100011111111111011111100110111', '11111100011101111111110111011001', '11111111111110001101011011101101', '01110111011011111100111101111110', '10001011110111011111111111110101', '11111100110111111111011110110010', '11111111101010110010110011111111', '01110111111101101011101111001111', '10001101111111010110111111011111', '11111010001111110101111011101111', '11111111110100101111110101011011', '01111111101011111111000111111100', '10001110111111111111111110010011', '11110001111110110110101111110111', '11111111010010101111011111111010', '11111111111001011101010001111111', '00101011101110111111101111011111', '11010101111101101111101001111111', '11111110110011011101110111100111', '11111111101111111000101110111100', '00110011011111011111111111101110', '11001100110110111111110011111111', '11111111011101100111111111100010', '01111111111111111010010110111001', '10001111111111111111001011111010', '11110011100110011011111111110111', '11111111011001111101011110011101', '10110110111111100110101101111111', '01001111111101011111010111011111', '11111001111010111101111111000111', '11111101000111100111111010111111', '11011110111011111010111101111001', '00101111111111011111100111100111', '11110001111110111111111101111000', '11001111111111100000111110111111', '00110101110111010111101111111111', '11111010111110111100110101111101', '11111110010111100110111101101111', '11111111001011101111011110101110', '11011110111001111011110011011111', '00110111111110101111001111111110', '11101001101111011111111010011111', '11111111100101110101011111111001', '11111111011001111011111100010111', '00111001111011111111111100101111', '11001111011110111011100111011111', '11110111110101101100111011111110', '00111110011111011111111111110001', '11000111111101110111111100111011', '11111000110111011111110111111100', '11111111101010110101111111110010', '10111111011111111010011011100111', '01010101111111110111111111100101', '11101010111010101111111110011111', '11111111100111001111001101111110', '01011111111011111010111010101111', '10100111111111111110110011010111', '11111001110101111010111011011111', 
             '11111110111101011011011101111100', '11111111001110110101100111111011', '00111010111111101111100111111101', '11001101111010011111011111111101', '11111111001111111101101001101011', '11110111100111111101011111000111', '00111011101111110011110101111111', '11001111111100101110011111101111', '11110111111011101011101110111010', '11111101011111110101111110110100', '00111111010111111101111010101111', '11001001111111101110111011111101', '11110110101100111111011101111011', '11111111111001011010101111010111', '00111111110011110111110111101011', '11100110100111011111111111011110', '11011001111101110101011111011111', '11111110011110011111101110110110', '01010110111011100111111111111011', '10101011011101011010111111111111', '11111111101110111111110000011101', '11111101110111111100100111110110', '01010111101110111111101110111011', '10101010111011111110111111100111', '11111101011101101011111001111101', '11111111111111010101011101001110', '01011011001111011101101111111111', '10101101110111111111010101111101', '11111110111101100011011011111011', '11110111110011101110111110010111', '01011011111111101111011101111010', '10101101101111111011111110101101', '11110111011110111001110011111011', '11111110111100111111111011100100', '01011100110111011111111111101011', '10101011111011110101101011111111', '11111111001111101110010101011111', '11110111110010111111100110111110', '01011110111110001111111111010111', '11111111101101110010011101111101', '10110111011111111110111110001101', '11101101110011011001111111111110', '01100101111110111111011111110011', '10011010111101111111111101001111', '11111011000101111111110011110111', '11111111111011100111100110111100', '01100110111010111110111111111101', '10011011111111100111110010111111', '11111101110101111101111001100111', '11111111001111010010101111111011', '01100111101011110001111111111111', '10011011011110111101111101111110', '11111100111111001111111110100101', '10111101111111111110001111011001', '01100111111111110111101001111110', '11011010110111111111111010101110', '11111111001100001101101111111111', '11111011101111111010010111011011', '01101100111110010111111110111111', '10011111011011111111010111110011', '10101111100101101011111111011111', '01110010110111111111101111100111', '11010111010101011001111111111111', '11111101111011110111011010001111', '11111111111011101011110101110001', '11111111111111011100101011011010', '01101010111101100111111111110111', 
             '10011101100110111111011111011111', '11110111011100011111011111111001', '01111011110111111110110001111110', '10011101111110111110111101110101', '11101111101101111101011100101111', '11110110011011111111111011101010', '10111011111101111011100110111011', '01101101101111111011011001111111', '11011111010110111100111110011111', '11111110111111111001100111001110', '11011111111011000110111111111001', '01101011111111101111110011001111', '10110101101110011111110110111111', '11110110110001110011111101111111', '11001111111111111111100111100100', '01110011111111011010111101011111', '10111101111011111100111110111010', '11111110011110111101011111110100', '10111111011111100101001111111101', '01101111100110111111111101110101', '11010010111011111111011011110111', '11111111111101000111101010111011', '11111101011001101111100111101111', '01101111011110111101111011011110', '11111111100111000010111111111101', '10110111110101111111011110101011', '11011000101111111111101111011110', '01101111101101110111111111011100', '10011101110011001111111011111111', '11111111111011111010110100100111', '11110011111111011111100101110011', '01110101011111101111110111111100', '10101110011111111111001100111111', '11011110101110111010111111001111', '10110011101111010101111111111011', '01111001110110111011111110111011', '11011111011111010111110011101101', '11101111111100111100101101111110', '11100111111001110110011111110111', '01111001111111000111111001111111', '10011111101101101101111110110111', '11111110110011111001010111011111', '11111110111011111110101011100011', '01110111011111101101011110110111', '10011001011011111111101111111101', '11101111110101011111011001111011', '10111100011110111011111111011110', '01110111110010011111111111011011', '11001111101110111101110110111110', '11111111100111101011100111100111', '11101011011111110110111101111100', '01110111111111101110110101101011', '10011111111111011010111111101100', '11111010101001110111001111111111', '01111110111101111110111010011011', '10110011101111111111111001011110', '11011101011011101001011111111111', '11101111110101111101101110010111', '10111110111110110111111011011001', '01111011011110011110011111110111', '11010111111110110111010101111101', '11101101110101101111111110101110', '11111110110111011011110011101101', '01111011011111110011101110111110', '11101100101011111101111101110111', '10110101111111110011011011111101', '11011111101011011110110111010111', 
             '01111011111100111011101001111111', '10111110100111101101111111101011', '11010111111000111111011111011110', '11101111011111011100111111101001', '01111100010011111111101111111110', '11111111111111100111100100100111', '11010011111111001100111111110111', '10111101110100111011110110111111', '01111101010111111111011101011011', '10101111101110110111111011101101', '11010011111101111111110011111100', '11101110101111101011111110110011', '01111101101101101111110111110011', '10101111110110110110001111111111', '11011111011011011101101111001111', '11110011111111010001111111111100', '01111101111001011111111011101110', '10110110110110110111110111110111', '11001110111111101101101101111011', '11111011111111101110011110010101', '01111111111010110111001101111011', '10111100111111011101111000111111', '11011011000011111011111111111110', '11101111101111111010110011011101', '01111111011010101011110110111111', '11011110110111010111111100011111', '11110111101101111110011111101010', '10110011111101111100111011101111', '10110111111001101101111101111011', '11011111100110110111101011110111', '01101110111111111111001111010110', '11110101011011011110111011111101', '10111011110110111110111111011010', '01011111101111011111011101101101', '11101001111111101001101111011111', '10111111010111111111010110011110', '11100010111111101110011111111011', '01101111111010111101110011110111', '11011100111101010011111111110111', '11011111010111110011111110101101', '10111001111110111111101011101011', '11110111101101111110100111110101', '01101111011011110101111100111111', '11111101001101011111011100111111', '10111011101011101110101111111110', '11101110111111110011110111001101', '11110111111111101011011100101101', '01011111110100011111111111110110', '10111100101111111111100011110111', '11011111011111111101011001011011', '11110100111100110101111111111110', '01111011110011111111111110001101', '10111101111011011011000111111111', '11101111011111101010111011101011', '11011111111101100110111101011110', '01110111101111011111110110111001', '10111101111111001111110101010111', '11011110100111111011001111111011', '11100111111011111111111010100101', '01111011010110110101111111111110', '11011010111001011110111111111110', '10101111011110111001111111111001', '11101011101111111100011011110111', '11110101110110101111110111001111', '11101011010011111111101101101111', '01111110111100110101111110110111', '10011111111111010011011111011011', 
             '01111101101101111110101010111111', '11110111110111110110101111111000', '11111100011011101111110101111110', '00111111111110111111111010000111', '11100111101111111001010111111101', '00111111111011111100100111011111', '11011011111110101011111011101110', '10111110011100011110111101111111', '01001011111101111101111010111111', '11011011101001101111111111101101', '11101101101111100111101111110101', '11110111011111111011110100110110', '11001010110111011111011111111011', '01110101110111001011011111111111', '11111110011011110111111001011011', '10110111100111111111100111011011', '11111111111110110100111100101110', '01011001110111101101111111111101', '10101110111001111111110011111011', '11111101001111010111011111110101', '11110111011100111010111111101110', '01011111110101111110110111001111', '10100111011110101111111001111111', '11111100101111010111101101111011', '10101111110011111101011110110111', '01110110111101111101001101111111', '11011100111010111111101111011011', '11111011011111011110110111100101', '01111110110111111011111100101110', '10011011101110111110111010111111', '11110101011101110011010111111111', '11101011111111001011001110111111', '01011111110111111111111101010100', '10101111001011011110011111111111', '11110111101111101101111011011001', '11111011111010110111110111100110', '11111101111101100011111111011001', '01101110010101111111111011111101', '10011011111111101010011101111111', '11111110101011110101110010111111', '10011111011111001111101111110110', '01111011111111110011011111100011', '11100111101100111110111110011111', '11110111110111011111101010110110', '11111101111011011101110111101010', '01111100111100111011011111011111', '11110101111110011101101101111101', '10011111111011111101111011011100', '11101011010111101111111100111011', '01111100111111110100111101011111', '10111010010110101011111111111111', '11010111111001011111101111111001', '01111111101110011111110111100011', '10110111101011110111111101100111', '11011111111101111010001011111110', '11101001110111110111110110110111', '11101110001111101111111110111100', '01111110101010011111111100111111', '10011111111111110101101111110001', '11101111010111111010011111011110', '01110110011110111111110011101111', '10110101111111101111111010110011', '11001111110101111101110101111101', '11111011101111010111100111101110', '11110111011110111110001011011111', '10111010111111011010101011111111', '11011011111111111001110100011111', 
             '01101101111011110111111111011010', '10111011111001101111011011101111', '01111111011101111001101111110101', '11011101110010111111111100110111', '11110110111111011110010111101110', '11101110100111101110100111111111', '10111011111010110001111110111111', '11101101111111101110111101110010', '01110111111101110111011011101101', '11111011001111111011101111001101', '01111111110110101110010111111101', '11110110011111000111111011111110', '11011101100001111111111101101111', '11001101111111011101011111011011', '01111111011111111001010101101111', '10011001111100101111111111111011', '11110111101011111101111110010011', '10111110100111111111101011111100', '10011110111110011101011111101111', '01101011110011010111111111111101', '11111101111101101110101110010111', '11100111111101111011110101011110', '11011101011111011110111110101110', '01111111101111110011111010110011', '10110110001101111101111111111101', '11101111110011110110110111110011', '11011110011101111111100111111010', '11110101101010101111001111111111', '10101011111111101111011001011111', '11111011110110011111111010011101', '11110111111000001111110111110111', '01011111011111110110101111101011', '10111110111111111001111101000111', '11101111100111110111111010111100', '00011111111111110110010111111110', '11111001111011111001111101101101', '01110001111111111101111010011111', '11101111111110001011011111110011', '00110111110111011101111011111101', '11101010011110111110110111111011', '11011101101101111110101101011111', '11111110101101100111011110110111', '00111101011111011011111111011101', '11001111101100111011111001111111', '11110110010111111101111100110111', '11101011111010111011101111101110', '01010111100011111110011111111111', '10111010111101110111011111111010', '11111101111111101111100010001111', '11111111010011010100101111111111', '01100101011101111111111111101011', '10011110111110111011101100111111', '11111011101011111111011011110001', '10100111111101100111110111111110', '01111000111011111110110111110111', '11011111111111001111111001001011', '11111111111110001100110110101111', '11111111110100111011110111111000', '01101011111111011101111110110110', '10111100111111100011111111101110', '11110111010011111111101101110101', '11111111100111110101001011011111', '01101111101011101111111110101011', '10011101111101110111111011110110', '11010111111110011100111101011111', '01111000001111111111011111111101', '10100111111111011110111100111011', 
             '11011011111000111100101111111111', '11111110100111111111011001110110', '11011111011111101011110111010101', '01111011111101111110111101101100', '10111101001010111101111011111111', '11100111011111110111101110011101', '11011111110101101011010101111111', '01110111110111110011111111010110', '11111110101111011111000111101011', '10101110111111110000011111111111', '11111101111110001111100111111001', '01111011111101101101110101110111', '10110111110110111010111110111101', '11001100111011111111011110101111', '11111111001111110111111011001010', '01111011111111100110101011011111', '10111111000011011111111110011111', '11011001111111111111011001100111', '11101111110001111111101111111000', '01111111101100111000111111111011', '11100110010111010111110111111111', '11111011011011011011110011111110', '10111100111111101111001101110111', '10111101010111110011111101111011', '11100111111111011111000011111101', '01010110111101111111111110010111', '11111011101110111100111111101100', '10111101011101111100111111011110', '11010111111110110111111111000011', '11001111111011101111110000111111', '01111011101111011001111110101111', '10111110110011110111011101111101', '11110010111110101101101111011111', '11001111011101011110111011110111', '01111101111110101111101111101100', '10111110111111101110010011111101', '11101111100011110011111110111011', '11111011001011111111100110110111', '11111101110110011011111101011110', '11001111011100100111111111111101', '11111011110101011101100111011111', '01110101111111111111011100101011', '01110110111011111011011111111010', '11010101110111110110110011111111', '10111111101001111101101111100111', '11011011011111011011111101111001', '00111110111110111100111011111110', '11101100111111111101101111101001', '11111111101011101011011110010111', '11110111111111110110011000110111', '00111011000111101111111111011111', '11101110111101111110011101011101', '11110111011101111101100010111111', '01011101101011001111111111111110', '10111011111110011011110111101011', '11101111110111011010111101100111', '11011101011110110111110110111110', '01011111111010110111111011011101', '10111111110101101101101111111010', '11111001110111101111001111101011', '01100110101111110111111111100111', '10010111001111111011011101111111', '11111111111101011110110010011110', '11111100101111011110111111111000', '11101011111010111101011101110111', '01110011110000101111111111111111', '10011110011111110011111011111101', 
             '11111100110110101100111111110111', '01011111111111111011101111001010', '11100111111111011101110110010111', '11101011001001111111111110111101', '00111100111101111110101111101111', '11101111101111100111010001111111', '10011111111010011111100101111111', '11110011011111110101011110101111', '00111110101111111101001110111111', '11001011111011101111111111010110', '11111101010111111111110011010101', '11111111110111111010111001101010', '00111111111000111111111110011110', '11010111110111111110011111110001', '11100101111111010011111111101101', '11111010111111011001111001111011', '01011110101101110111100111111111', '11101101001110101111111101101111', '10110111111111101001010110111111', '11111011110101110110101011111101', '01011111111011100101111101101111', '10101011111100011111111111111100', '11101111001111111111101011010011', '01111110011001011001111111111111', '10111011110011111011110111110101', '11010110111110101110111110111011', '11111101011110110110011111011110', '11110101100111111111101101111010', '01101111100111011101111111011011', '10111111011001100011101111111111', '11111001111110011111010110111110', '01111110110111101111111011100011', '10101101111101110111101101011111', '11010110101111011011111011111110', '11011111011010111101111011100111', '11110111111111111100010110101101', '01111111011110011011001111101111', '10111101101101111111111101110100', '11011010111111111110110110011011', '11100011110011111111111000111111', '01111111101101011011111101010111', '11010101111111101101111111100110', '10111111111011100110011110111011', '11111110110110111110110011011101', '01111111111110011110011101111010', '11011010111101111001011110111111', '11100111000111111111110111101101', '10101011111111110111100111110101', '10111011101111111101110111010110', '11011101110111111011101010011111', '11100111011011100110111111111011', '01111100111010100111111111111101', '10111100111011111011111110111001', '11011011110111000111010111111111', '01111111001110011111011011011111', '01111111110001111111101101001111', '10111111111110110101011001111011', '11000011111111011111101101111110', '11111111011101111110100111100110', '11100110111101111010111110101111', '10111111011101001111111111000111', '01111101101111101001111011111101', '11011101100011111101100111111111', '11111010111110110111111010110101', '11011111011001101111111010111011', '11101101110111111010100111111011', '11110110111111110111011101101100', 
             '10101111101110111110111111010110', '11011111101101111011111110011100', '11111011011011110110010101111111', '01110111011111011101101011111011', '01101100110110101111111101111111', '11100101111100101101111110111111', '11111011111111110101110011011001', '00111111100111011010111111110111', '11011010011111011111011111100111', '11101101011110011111101011111110', '11111111100111101101110110110101', '11010011111111110010101111111011', '10111110111011101111011101101011', '11101111111001110110111011101110', '00110111111111111111011100010111', '00110111100110111111111101101111', '11111010011011111111110111011100', '11101111101000111111110111011011', '00110011111101111111101111110110', '11011110010111100111001111111111', '11111101101110010000111111111111', '11111100111011111111101000111110', '01111101111111011101010111011101', '10001111110111111001111101101111', '11010011011111111011111011110101', '11110101101001010111111110111111', '11011011111111101110011110101011', '11111110011111101101010011110111', '11101111111100111111111111001000', '11111110101011000111101111011111', '01111111111111111010101001110101', '10011011110111111101110111101011', '01110101110101111111011110111110', '00110111111001111110110101111111', '10011101001111110111111111001111', '11101011111110011010111001111111', '11101110010111011101011111111101', '00111011110011111110011011111111', '11001110011101110101111111101111', '11110101101111011011111110011011', '10111111110110101111101110110110', '01001111001111111110111111111001', '11110010111001111101111111101011', '11111111111110000011011110011111', '01111110111111110111100101110110', '10010011011111111111111110111010', '11101101111001111010010111111111', '11111111101111011111111001000101', '01111111010100101111101011111111', '10101100110111111101111011011111', '11011111101011111101011110111001', '11110011111110101110111111100101', '11111111001111110011100101111110', '00111110110101011111110111011111', '11010111111011111111110001101110', '11111101111111110001011101111010', '01111110111110101110001111110111', '10101111010111111111111001110110', '11000111101011111111101111011101', '11111001111101011011101111101101', '11111101111110100001110110111111', '01011111100111101111111000111111', '10110010111100011111111110111111', '11111011111011010010111111110011', '11101101111111111101010111100101', '01100111111111001010111111111110', '10111111011110111111101101011001', 
             '11111100011111100111101110111011', '11011111101001111111010111100111', '01110101111011111111111001011101', '11001011110110111100111111111110', '10111010111111010110111111001111', '11111111010110111111010110110011', '01111001111101110111110111111010', '10011111111101111111011010110101', '11100110110110111111101011101111', '10101111101011101001110111111111', '01111010001111110111111110011111', '11110101101111001110111101101111', '11011111110111101100011111111100', '11111111011111011001101001110111', '01111010110110111111100110111111', '11101111101101001111011111011101', '11111111011001111001111011111010', '11110101111011110110111101011011', '01111101001111011110100111111111', '11100111110110110111011101011111', '10111011111000111111111111110001', '11011111101111110001111011101110', '01111111011011001111111011110101', '11100111110111101111000111110111', '10011110111111111000111111111010', '01111101011111111111001110100111', '10101111111011011111110101101101', '11111010111110100011111101111110', '11011001111101111111101110011011', '10110111111101111000111110011111', '01111110101111111101110101011011', '11011100111111111011011111110100', '11111111110000111111101011101110', '11010111000110101111111110111111', '01111111001000111111111111110110', '11011100111111011010110110111111', '11100011111111001111111011101011', '10111111110111010101111111010110', '10111001011111111100101110111111', '11110111101010101011111101111101', '11101011111111110110011011001111', '11101111111101110111000101101111', '01111111011101110111011111010011', '01001001111111111011110111101111', '10111111110011111110111000111101', '11011110101110011101101011111111', '01111111111111010100110011110111', '11111011100101111011111101111001', '10011111110111101111111111001010', '11100100011110111111011110111111', '11101110111101001111110111110110', '10010111111011111100101111111101', '01111111010111101011111101111100', '10110111101010111111101011011111', '11110001101111011111011111110110', '11111101111010111110011101101101', '10111110011111110111110110011011', '01101110110111111011101010111111', '11110100011101111111111101100111', '00111111101101101111111111101001', '11001111111111101111010110011110', '01110011111111100101110111111101', '10011111101010010011111111111111', '11011011111101010111111111101010', '11111111110010111100001011111111', '11101011110111111001101011110111', '11110111011111001110110111011011', 
             '11011000111111111110111000111111', '00111101110100110111111111111101', '11101111111011111101001111101010', '00100110111111011111011011111111', '11011011000111111110110101111111', '11111111111111100011111100010101', '11111101001011111111111111000011', '00110101101111111110011111011111', '11011110011110110011111111110011', '11101110111011101011111001111101', '00111111011100111101010111111111', '11100111101111111111101010101110', '11011101111011100110101111111110', '11111010110100111111110111101101', '01101111111111011001111100111101', '10110101111110011111111011111010', '11011111000101111111101111011110', '11111011111011101101111110100011', '11111111110101110000110111110111', '01001101111111111101101111111100', '10111110001111111010110111110111', '11110010111011011111101110111011', '11111011111011110011001101011111', '01011011111110010111110111011111', '10101111100101011111111011101111', '11111111111110101101011100111100', '11110100110111101110111011101111', '01010110011111101011111111101111', '10111101110011011111111101110011', '11111111111101111101011100010110', '11101011101110110110110111111101', '01011110101111111111011011001111', '10111111011101111110101110011011', '11101101111010111011101111110011', '11110011011101100111111001111111', '01011111110110111001110111111101', '10111010111111011111011010111110', '11101111010111110101110101011111', '11111101101011111110001110111011', '01011111111101001111001111110111', '11110101111001111111111111001100', '11100111101110111001111111100111', '11111011110111000111111100111110', '01101011011011111111011110111011', '10111111111101010011111001111110', '11111100111111111110110011110001', '10110111000110111100111111111111', '01101110111110111111111110111000', '11011110111101101111100111001111', '11111101100111110110111111001101', '11011111011011001111011101110111', '10100111011111111110100111111110', '01111011111111111001011011101101', '11110010101111111011110010111111', '10111111111110000111101111110011', '10111111010110110111011111100111', '11101111110111101111101011011001', '11011001111001111101111100111111', '01110110111111011001110111111110', '10111111110101111011011011011101', '11011111001101011111110110111011', '11001101111011110110111101110111', '01110011111011101111111101011110', '11101010011100111111101111110111', '11111101100111101100111111101110', '11111100101110111110010111101111', '11110111111111110001111100111001', 
             '11101101011011111011110110011111', '00111111111011101101101001111111', '10011111110100011111101111101111', '01010010111111111111111111011001', '11110110110011111010101111011111', '00101101101101111111110111111110', '11011011101111110111111001110011', '11111111111010011011011010111011', '11111001011111011111111100001111', '01101111010111111111011011101110', '10010111111101010111010111111111', '11111110011111101100111101110101', '01010001111010111111111011111111', '10101111111101011101110111110011', '11111111111110110001111111000101', '11001111101111101100101111111110', '01111001111001101011111111111011', '10111111101111010111101110111100', '11111110110111111110011011000111', '11110111101110110110110101111110', '01011011101111111101010111111110', '10101110111000101111011111111111', '11111001010111111111100110111101', '01011110111111010110111101111101', '10110111111110111001011111110110', '11101111010111101110101110101111', '11111100110111011111101011011011', '11110111001011111011111110101101', '01011111011011110111100011111111', '10110011101111011110111111011101', '11101101111101100101111111101011', '11111110110110101111011101010111', '01011111110111101010101111111011', '10110011111010111111010111101111', '11111110101101010111111011010111', '11011111111011011011111100011110', '01100101110111111101110111111011', '10111101111100111111001010111111', '11111110101111111110111100100110', '11101111011111100011111111111000', '01101110111111111101111011010101', '11111011011101011111001001111111', '10011111011111101110110100111111', '11110101100110110111111111101110', '01111010111101101111111010111110', '10111111110111111011101111000011', '11111111101011010101110111110101', '11011011011010111110111111111001', '01111111101001101110111100111111', '10011111111100111111110001111011', '11100111011111111011011111000111', '11101101101111001101110011111111', '10111111111100110110111100110111', '01111011011111011111111111011000', '11010011110111111111011111101100', '11111100010111111001101111111101', '01111111111101001100111111001111', '11011110100011111111111111110010', '10100111111111110011100110111111', '11101101111011111001001011111111', '01111111111000011111110110111101', '11001101101111110111001111101111', '10110010111111110101111101011111', '11110110111110111011111001110011', '01111111111110111110100101001111', '11011101010001110111011111111111', '10101000110111101111111111111110',
             '11111111011111111110011010110100', '01111111111111010111110000101111', '11110001010101111110111111111011', '11111010111010001101111111111110', '00111111001111111011111000111111', '10111001111111101111011111001101', '11010111110101100101111111011111', '11010111111011111001101111110011', '11101010101111111101101110111011', '10111101011111101111010011111110', '11010110111110110111101111101101', '01101111100011011111011111110111', '01001111011111111010111110110111', '10111111110101100111110011101111', '11101001111011011111111111010101', '11110111101101111001001111011111', '11011111111110110110101101111010', '11101011101011111110111011111010', '11111101110111111110110100101011', '10110110111111001111111101110101', '11010101111100111011111111101011', '11111010110001011111111110110111', '00111111101110100111111101111110', '01101110011111011110110011111111', '11010111111011111001011111011101', '00111111011111111111011101100101', '11101011101110101011110111111110', '11111101111110110101101111011010', '11111110100101111011110110011111', '11001101111110100111111011011111', '00110110111011111111111110111100', '11111111000111111111010011101011', '01101111111111011100101110011111', '11011101111100110111100111110111', '10111110100001111110111111111101', '11110011111111011101111011100110', '11110111010111111010001101111111', '11111111101010100100111111011111', '01101110111111001111101111101110', '11011001011111111101110011111011', '01101011111111110011011101111101', '11111111010011101001111111001111', '11010101111101011110011011111111', '11111011101101111011111110110010', '10011011111111111111001001111101', '00111111110111000001111111111111', '10101110111011111111110101011110', '11111101011100111111111110101001', '11110110111110011111101111110001', '00011101010111111111101111110111', '11100111011111101101111111011100', '11111010111100110011011111101111', '11111101101111101110110000111111', '00111111111011110100111111101101', '11001110001110111111011111110111', '11111111111001011111110100111010', '11111011100111111010111101010111', '00110001111111111001101111111111', '11010110111111111111110110100101', '11101111110110010111101100111111', '01111111101111110111001011111010', '10111100001111001111111111111011'],

    #min Hamming dist=8, r=0.75, min column sum  703 and max  838, avgHammingDist=11.8
    '24/32_D8':['00110011111111111111111100110011', '11101110011111100100110111111111', '11011111110010111011111111001110', '00111111101010011100111111111111', '11011100111111101111101010111110', '11100001101111010111111011111111', '01011001111100111111011111111101', '10111111110111011111111000011110', '11110111111111111101100101000111', '11111110010001111111011111101011', '10101111001111110011111111011101', '11100101111010101111111110111101', '11111111100101101001011011111111', '01011111011111010111111101111100', '01101100100111111111111110011111', '10110010111011101011101111111111', '11111011111011111110010111110010', '11101111011111001111101111001011', '10111111110101111110110010110111', '11010111011110111110001011111111', '01111101111111111101101111101000', '11011111111110011111010111100011', '11011001110111111110111101100111', '01111110011101110001111011111111', '11101111111101010110111101110011', '11110111111100111111010111011100', '10011100101111111010111111111110', '00111011101111111111101010111101', '11110011101011110101111111101101', '11111111110011000011001111111111', '10000111111001111111110101111111', '11111001011110111011111101011011', '01101111011111111111011010101110', '11111111100111001101111101111001', '11111110111111110111110011110000', '01011111011001111110111110011111', '10111110111110111111100100101111', '11101101110101111011000111111111', '10000111011111101101111111110111', '11111111111100011011111000111101', '01110010110111101110110111111111', '11111011101111101011001111101110', '11101111110111100101111101010111', '11110111111111110110111011001010', '11111101111100111100111111010101', '01111110001011011011101111111111', '10111000111010111101011111111111', '11101111101011011111110111010101', '11011111011111110011101010111011', '00111010111101011111111111111010', '11010111110111100100011111111111', '01011010111111111111110011001111', '11111101010110111101111100111110', '11111111101001111111011110110001', '11110111111111100010101101110111', '11111111000111101110111111010110', '10001101111111111101111001111011', '01100011111111011111010110111111', '10111110111110100111111111001110', '01101111111111111001011111100101', '11111001001101011111100111111111', '11110101110010010111111101111111', '10111110101101111011100011111111', '11011011111111001110111110011101', '10010110111010111111111111101011', '11111111101011110110001110101111', '01111111010111111011111001111001', 
             '11111110111111111101001110010110', '10101001111100111111110011111111', '11101111011011011110111111101100', '11011101101100101011110111111111', '00111101110111110110111110111011', '11010111111101111001111101110011', '01101111101111111111001101011110', '11110011010110011111110011111111', '11001111111100111111111110100110', '00111111111111001111011011011011', '11110101010111111100100111111111', '11110100111001110111111111111100', '11101110111111010011111100101111', '00111011011111110110111111010111', '11011111111110101011011101111001', '11100111001011111101110111111110', '11111010110011111111111010011011', '10011110110111111101111101101101', '11111001111101010101111111100111', '11111111101010101010101011111111', '10110111110101111111011110001111', '11101001111111111110101111110001', '01111111101111101111000111111001', '11111010111101101111011001111110', '11110110101111101111111010101101', '00111101111011111001111101110111', '11011111010110111111100111110110', '11001111101010010011111111111111', '11101111111011101111110100111010', '10011100111111011111010111011111', '01110111011100011101101111111111', '10111111111111010110010111101110', '11111011111001111110101101001111', '11101011111111101011111011010101', '01110111110110111000111011111111', '11110110001111110011111111111010', '11011101110011111111001111011101', '01111110100101111110111111100111', '10001011101111101111111110111011', '11111100010111110101111111001111', '11010101101111011111111101110110', '10111111011110011110011110111101', '01111111111110101111101010110011', '01011111111111110101010101111011', '11111111111101001011110101011110', '11111011111010111001111110100111', '10101010111111110101101011111111', '11101010011111111111110111101001', '11001111111011011101111011011110', '01110101111011111110101101111101', '01111101101101110111010011111111', '10111011010111111101101111111010', '11111100111001111111111000110111', '01011111001110111111110110111101', '10101111100100111010111111111111', '11110110111110100101111100111111', '01101101110101101111111111101110', '10111011111111011011110111110001', '11010111001011101011011111111111', '11101001111111110110111110001111', '10111111111111010111101101011001', '11010110011111011111111111000111', '01111111111110101100100111111110', '10011111010111111111011011110011', '11110110111101011010111110111110', '11101011111110101111101101101101', '11110101101011111100011011111111', 
             '10111111110111110011111110101100', '01101110110110011111111101111011', '01011111111111111010101011011101', '11111001011011110101110011111111', '11111011101100011111111011101011', '01110111111111110111011110110100', '10111110011101111011011101011111', '11001111110011110101100111111111', '10011111101110101110111101110111', '11100101111111111101110110011011', '01110100111111101011111011110111', '11111111111011101111101111000100', '11011101000101111110011111111111', '10111111101010111111011010111110', '01101111101011110111111111001011', '11110111011111010100111111110101', '10111011110101101011110111101111', '11101010101001111111111111110110', '11111011011111010111011001011111', '11111111110100111111100101111001', '11111100111111001010100111111111', '10111101011111111111110011100110', '01011010111111111111001100111111', '01111111100100110101111110111111', '11110110101011111111010101101111', '11111111110111111010011110011010', '01011111110110111101111111010011', '10100011111101100110111111111111', '11111101011111011111111011011000', '11111111111101001101011110101101', '11101101100111111111111001110101', '01001110011110110111101111111111', '11010111111011011000101111111111', '11111101101101111011111100001111', '01011010111111111100111111111100', '10110111010011100111110111111111', '10110111011111011011000111111111', '11111111011110111100111101100011', '00110101111110101111111111111010', '11101011111011011011100011111111', '11101111111101110111101110111000', '01100011011011111111111101101111', '11111110101001111110111011011101', '10011110111111111001011010111111', '11010110110111101111111110110011', '01011111101101111111101011101110', '11101011000111011011011111111111', '10111011110110110100110111111111', '11111100011111101111111110010101', '10100101111111110011111111101011', '11111011111010110111111011010110', '11011101110101001101101111111111', '11011011111111101111010101010111', '11110110111111111110110100111001', '01101101111111011110111111010110', '11111111101010100101010111111111', '00111111100101011111001111111111', '10011111011001111011111111111010', '01111101111110111111001110001111', '00110111111110111111011001111101', '11110101101001011111111111011011', '11011111111110110011111001100111', '11111110001111111110111100101110', '11101110010011010111111011111111', '11101011110111101000101111111111', '11011111111101111101110100111100', '00111111111111001111100111100111', 
             '11111011001111111101111111010001', '11100001110110111110011111111111', '11110111110011111111001101110110', '01011111011011001101111111101111', '10111000101111100111110111111111', '11111111101111111011110011001100', '10010011111111110101111110011111', '11101111011001101111111101110101', '01101100111101111111101011111101', '10001111111011111110101110111110', '11110111111110110011111110011001', '01111011111111100100111011101111', '11111100111100111010011011111111', '11111010111110011111110101110110', '11111111010111110111110100110011', '01010111111001111011111111101101', '10111110001111101101111011011111', '10101111001110111111101101111011', '01111110110111011011010011111111', '11110111110110011101111111101010', '11011101111111111010010111110101', '11101101100011011110101111111111', '11111010110111110111111101011100', '10101111111011101010111111001111', '10111101111101011111011100111011', '01111011011011110111101110111110', '11000111011111111111101110101101', '01011010111111110011111111110011', '11110101100111001111010111111111', '10111110110100011101111011111111', '11111101111011110011111001111010', '01011111111111111110100110101011', '11111111001100111100110011111111', '11011101111111001111111001101101', '00110111101111111111010111010111', '11101111111110111011101111010010', '11110111111001101101111110010111', '10111011111011111111011100101101', '11101110111111001011111111111000', '01010110111100111111110111110111', '11111001001110101111011011111111', '01111110110111010100101111111111', '10111101111101111100111101101110', '11100111000111101111111011111011', '11011011010010110111011111111111', '01111111011111011011111100010111', '11011111100111111110111111101000', '10100110101111110111111110110111', '11101101111010110111001011111111', '11101010111111111100111101011011', '10111111111101110111110111000101', '11111001010101111001111111111101', '11111111111100001111000011111111', '01011111101011111001110111011111', '10110111111111011100111010101111', '01111110111010111110111111011010', '11110011010101101111001111111111', '11011111101111101011111110110100', '10010011011111111010111101111111', '11111100101111111111100110110011', '01101111111101100101001111111111', '01101111111110111100111100111101', '11111101101110111111011111100100', '10100111111111111011101001011111', '01111011100011010111110111111111', '11011111111010011111101110011011', '11011111111101111101011001001111', 
             '10111110110101111111011111110100', '11110110011011111010110011111111', '11001001111110100101111111111111', '11110011100111111111111001101110', '11111111111111100011011110100011', '01111111010101110111101111011011', '11111101110111011111110110000111', '10010011111101111111101111111001', '10101011101111011111111101111100', '01101100111110111111010111111110', '01111101001011101110110111111111', '10011111010110101111111110011111', '11110101111101101111100111101011', '11101011111011010100011111111111', '11111010111111111010101010101111', '10111101111111110101011111011010', '01011111110010011111111011111101', '11101110101111011000111011111111', '10011100011111110111111101110111', '01110111111011111111110001011011', '11110110111110111110101111101100', '11101011101101110001110111111111', '10111011011011101111111010110111', '01011111101111011110011101101111', '11111101011111111011101101110100', '11100111110100101101110111111111', '00111011101111111001111111101011', '11111111011111111110100010011110', '11000111110111111111111101011010', '11111100011010100011111111111111', '00111111111111000101111110111110', '11110111110111011011111101100101', '11101111011100111111011011111001', '11111000101111011110011110111111', '11011011111001101111111111100011', '10100101011111011111111110111110', '01011111100101101111111111011101', '11111111110000111100001111111111', '11110101011011111111011111001110', '01111011101110011011111111011101', '10111110111011101111111001111001', '11011110110101110111001011111111', '01111111101111111101110110100110', '11111011011111011101101100111101', '11110100111010111111101111010111', '11011110111111110111010110101101', '00111111111100111111111101010110', '11100111110111010010110111111111', '10011111101011110101111111110011', '01101111111101101010110011111111', '10001110011101111110111111101111', '11111011101111111011010100111011', '11110011111111001111111111010010', '10111101110111010111100011111111', '01011001110011111101111110111111', '11101111110111110111011101101001', '11110101101100111111101001111111', '11101110011111101011001011111111', '11001110111111111110111010010111', '00110111101111110110111101111110', '11111111110011111101110111100001', '11011011011110001011101111111111', '01101011110111111111101111000111', '11111110011011111101111010111100', '10110111011011011101111101111011', '01111101011111101111111100101011', '10111111111111101001101011110110', 
             '11001111111100110110010111111111', '11110101100111110110111111011101', '11111001101000110110111111111111', '11111100001111111001010111111111', '10001011111010111111111111011101', '11111111110110001111101110111100', '01110111111111111011010111101010', '11111010111100111110111110110011', '00111110111011110110111111101101', '11010111111111110101101001111110', '11111100010101101111110011111111', '11011001011101111111111111010110', '10111110101110001011011111111111', '11111111111011000111111010001111', '01101111100111111100010111111111', '10111111100111111011111101010011', '01101001111111110011111111111100', '11101110111110101111011110011011', '01101111111101011111110101101101', '10110111110110011110101111110111', '11011110111011111011111100011101', '11011011011011111111100101111011', '11110101111101011001110011111111', '01111111011111011111001011110101', '11101111011111111001111101001110', '11111011101111110101111010111010', '10111110100010110111101111111111', '01100110011101111111111110111011', '10010101111111101011111111011101', '10100111111111111110011101100111', '11110101110111111111101010111001', '01011101111110011001111111111110', '11011110111011111111011011100110', '11111111100101100110100111111111', '00111011011111111111010101111110', '11110110111101111101111111001001', '11101111101111001111011000111111', '01100011101111111010111111110111', '10111111101011011111100111111010', '11011111110011111111101000101111', '11111010111111111110011111000101', '11111111111100000000111111111111', '11111001111101101100010111111111', '01111110101111101111111101110010', '10110001011110110111101111111111', '11111101011000111111010110111111', '11001111011010101111110011111111', '01010111011111101111101111011110', '10001101111011011111111111100111', '11111111100110010110011011111111', '11101011111101011111011111001110', '10111011111111111110110001101011', '01010101111111110011111100111111', '11011101110111110101111111110100', '00111010111110101111111111110101', '11111111000111111111011100011101', '11110110101000111001111111111111', '11111111011011111011111011000011', '11011010101110111111111110011110', '10101111111111101101101110011101', '01111111011111100011101111101101', '11111101111011011101000101111111', '11110110010101110110111101111111', '00111110110111111001111111011110', '11101011100101111111111110101101', '11010111111011010111010011111111', '10101111011111111010111110110011', 
             '01010101111111111111001111110011', '11111010111101010110110011111111', '11111111101101100111111101101100', '11101101110110001011111011111111', '10110111010111111110111011111100', '01111111111111100110010110011111', '01111110111111011101111110110001', '10011001111011101111111101111110', '11001111111101111011110111001011', '11101101111011111111011101010011', '11111111100110011001100111111111', '11111010011000111111101011111111', '01111111101111111100111001010111', '10011110111111001100111111111011', '11100111010111110111111111100110', '11110011111100111010100111111111', '10011111001101111111111000111111', '01101010110011111111011111111101', '11110111101111011101111110011100', '10111101010010111110111111101111', '01010011111110101111111110101111', '11111100111101111111101101011010', '11101101101111100010011111111111', '10011010110011111111110111110111', '01100101111111001101111101111111', '11111111000011110000111111111111', '11110011011011111111110110011101', '11001110111111111111101101100011', '00111101110111111111010111101101', '11111111111111110000000011111111', '11110101010100111111111111110011', '01011011111111011111111010110110', '10101110111001011111111110111101', '11111111101110111101110101011010', '01111011111111010111001111101011', '10110111111001110111111010111011', '11101100101111110101111111111001', '11111111011111001111011101100110', '01111111111010110001101111111011', '10101001110111111011111100111111', '11010111011101001110110111111111', '11011110101111100001101111111111', '10101111011110011111111011010111', '11110001111111111111011101111000', '01011111110001111111010111111110', '01101111101011101111111011111100', '11111011011100111110111101111100', '10011101111110111111101011110101', '11111110110111101111110101001011', '00111001111101101111111110011111', '11010111011111111100111110111010', '11100111110011111111111011001101', '10101100101111111111011011101111', '01011111001101011111111111110011', '11111010111101011001001111111111', '11111110111001111111110110001110', '01100011111110111111101011111110', '10111111001111100110111111101011', '10011111111111010011111111010110', '01111101111011010101111111011101', '11111010100111111101111100110111', '11011101101011111110111100111011', '11100111011111101110111100011111', '10101111111110100011100111111111', '01111111100111001011111110101111', '11010111101110111111111101001101', '11110011011001010011111111111111', 
             '11111100111100110101100111111111', '01101111110101111111011100110111', '10011111101100111111011111011011', '11110110110010101111011011111111', '11111001010111000110111111111111', '00111111111111001010111101111101', '11110011101111111111101110001011', '10110111111111101111110101110100', '01111101011001111111101111100111', '11011110011111011101100011111111', '11101001111010111111111111101010', '11101110110110111110100011111111', '11011110110101111000110111111111', '11110101111110011111011010110111', '10101110010111101111111101111110', '01011111101111110111101110010111', '01111111111001111011001010111111', '10111011111011011101101111010111', '11101011001111100111101111110111', '11010100101110110111011111111111', '00110110100111111111111111111001', '11011011111011100010110111111111', '11101101011111010001101111111111', '01111110111111011111100111011100', '10100111111111110101010111111101', '01111101111111111110111010100101', '10011111111111111111110010011001', '11110000111111111111111110100110', '11001111110011111010011011111111', '11111111000000001111111111111111', '11111111001100110011001111111111', '01010101111111111100111111001111', '10111011100101110111111011011111', '11111111111111101001111000011011', '11111110011111111111101001001101', '11101011111000101011011111111111', '01011101100111111111100101111111', '10110111111001001111011111111110', '01011101111101100110111111110111', '10111111101101011001111110110111', '11100111111110111111111000101011', '11101011011111111111111001110010', '11111111011010010110100111111111', '00111011111110111010111110111110', '11100111101011111011111101111001', '11011000110111101011011111111111', '11111111010101011010101011111111', '01010011111101011111111101011111', '10111111110010101001111111111101', '01111101111111110111110101001110', '10011111001110011111111111101110', '11111011110111101101111110001110', '11100100011110111101111011111111', '11101110111001111101010011111111', '00110111111110110101111111100111', '11001011111111110111111100110101', '11111100011001011100111111111111', '00111110111011111111010110111011', '11101111100111011111111110110010', '11010010110110111101101111111111', '11111100001111110110101011111111', '01111011000110111110111111111011', '10111101111111111110101100010111', '11010111111011111110111111010001', '11101110101111010111000111111111', '01011110111101111110111001111011', '10101101110101111111111111011001', 
             '01111111111010111110010011101111', '10011010001111111111011111111101', '11100101101111101111111111000111', '00110111111101111111100110111110', '11011001111111111011111110101001', '11100010101111101101011111111111', '01111011110111111111110110111000', '10011111011011110111101111001111', '11100100111011011011011111111111', '10101011111111111111110110010110', '01011111111110100111011011111110', '11110101010111110011011011111111', '11111111110011001100110011111111', '00111111001111111111111101100101', '11010111011010111111111100110111', '11111010100111001111101011111111', '11101101010011101101011111111111', '01101110111011110101111101111110', '10111011011111101110100111111101', '10001011111111111011111011101110', '01011100010111111111111111111010', '11110110101011000110111111111111', '11110101111110100110110011111111', '00111101111011111111101011011110', '11010010101111011011110111111111', '11111111001111000011110011111111', '00110111011111111001111110111101', '01101110111011101111111110100111', '10011110111100110011111111111101', '11011011001011011110111011111111', '11100111101101001011101111111111', '11111001111110011100101011111111', '11101101101100011101011111111111', '10101111110110101111111111100011', '01111011010011101011111111011111', '11010100110111011110111011111111', '01101111010110111111111111011100', '10011111111111111110011101011100', '10110111101101111111111111100010', '01101001111111111101011011011111', '11011011111011101101001011111111', '11110110001110101111100111111111', '11111100101001101111001111111111', '00111001111110011111111101101111', '01111101111110110111111101110001', '10011111101011101111110111101101', '01111101111101111011111110110010', '10010111111111001111101100111111', '11000110101011111111101011111111', '11100010110101111011111011111111', '11101011011110111101000111111111', '00111100111111111111111111000011', '11000110111101010101111111111111', '11111111011001100110011011111111', '11111111010101010101010111111111', '11111111010110101010010111111111', '11111111110000110011110011111111', '01101100011111111010111101111111', '10011011110111011111111111001011', '01011111111111101101101101110101', '10100011011111111111011111011011', '11110011110011111001010111111111', '11111100100110101100111111111111', '11111111101001010101101011111111', '01100111111111101110111111101001', '10111011111111110111101101100110', '00001111111111111111111111110000', 
             '11010001110101110111110111111111', '11111100010110011111001111111111', '11111111000011111111000011111111', '11111111101001011010010111111111', '01100101110011111111110111110111', '10011111011101011101111111011101', '00111111110011111111111101101010', '11001100111111111111111111001100', '11110011001111111001101011111111', '11111010111110101001110011111111', '01101101111011011111111010111011', '10111011010101011111111101110111', '11010111101110001101111011111111', '00110110111110011111111110011111', '11001010111101101111100111111111', '11111100100101010011111111111111', '11111111001111001100001111111111', '01111111101001011111111100111110', '10010111111111111011110110100111', '00111011111101110101111101111101', '11000101111101101111011011111111', '11101011101110001110110111111111', '11111100110011111001101011111111', '11111111011001101001100111111111', '00110111111101111010111111011011', '11011000111011010111101111111111', '11101110000101111101101111111111', '11111111010110100101101011111111', '01111111111111011001101001101111', '10011111111110110111111100111010', '01010011010111111111111111110101', '10101111100111010101111111101111', '11100001111001111101101111111111', '11111100110011110110010111111111', '00111011111101111111011011100111', '01010101111111111111110011111100', '10011101100111011111111110111101', '11100010011111011110101111111111', '11101110001010111110011111111111', '01011111110111101110111100111110', '10111011111010000111111111111011', '00111111110011111111111110010101', '11000011111111110011001111111111', '11100111111000011110111011111111', '01011111010100111111111101101111', '10101110111111111101111110101010', '01100110111111111111111101010101', '10010101001111111111110111111011', '11111001100111111010110011111111', '11111001011011111010001111111111', '11111100101010011111110011111111', '01011011101111101011111001111111', '10110100011111101110011111111111', '11101110110110110001011111111111', '11111111011010011001011011111111', '01011111011111111010111111100110', '01100111111011111011111110011110', '10010110111101111111111011011110', '10101111110001101111101011111111', '11111010111110100110001111111111', '11111010001110010101111111111111', '01011001111111001111110111111011', '00110101111101011111111111110101', '10010101110111111111101111101110', '11101101001001111011111011111111', '11101011110111100111010011111111', '00111110110111111111101001110111', 
             '01011111011111111111011111001001', '10010011111110111111011111110110', '11110011100110100011111111111111', '11101101011100101110101111111111', '11101101111010111000110111111111', '01010111111110010110111111111011', '10111000011111011011111011111111', '00110011111111111111111111001100', '11001111101001101100111111111111', '11101110011100011011110111111111', '11111100111111000101011011111111', '01010111100111111111011010111111', '10111011100011101110011111111111', '11101110110101001110011111111111', '01011100111110101111111101011111', '10110001110111101101111011111111', '11101110111001110010101111111111', '00111011111110111111100111011011', '01011100101011111111111111110101', '10000111101111011110111111011111', '11100111011101110111100011111111', '11111010101011111100100111111111', '01101001101101111111111101111011', '10010101111100111110111110111111', '01111111111011010010111011110111', '00111111111100111111111110101001', '10011001111111110110011011111111', '11000011111111111100110011111111', '11110101001101100101111111111111', '11101110100011101011110111111111', '01011111111011100111111110111001', '10110010011101111101110111111111', '11101101000110110111110111111111', '01111111111101011100011011111110', '10001110110111011011101111111111', '11110011101010011111001111111111', '01101001011110111111111110110111', '00110110111101101111111101101111', '10011111100111111100101011111111', '11011011100001111011101111111111', '11110101111110101001001111111111', '11101101111001000111110111111111', '01101110001111111111110011110111', '10011111111101101010001111111111', '11110011101001101111110011111111', '01101111010111101111100110111111', '10011001111111111001100111111111', '11110110011011110101001111111111', '01101010111111000111111111011111', '10110100110110111011110111111111', '11011110000110111011111011111111', '01011100111101011111111110101111', '00111100111111111111111100111100', '10001101101101110111101111111111', '11100111011101111000011111111111', '11110011110011110110101011111111', '11111010110010011010111111111111', '00110111011111111111101011101011', '11011011111000011101110111111111', '11101101011111011110010011111111', '01011001001111110111111111101111', '10101111011000110101111111111111', '11110110100111111010001111111111', '01110011111101101001111111111110', '10011111111101100101110011111111', '11101110101100100111111011111111', '01100110101111011111111111101110', 
             '10011111011011111100010111111111', '11111001110001011111011011111111', '01101011111111110110100101111111', '10011111100111110011010111111111', '11110101001110011010111111111111', '00111010101011111111111101011111', '11001111010101100011111111111111', '11110101101011110011100111111111', '01010110111111001111011111111101', '01011011111010111110101111110111', '10110010110111010111011111111111', '10111101011110001101110111111111', '11101110111010001101101111111111', '11101101110101110100111011111111', '00111010010111111111111110101111', '11011101011111101000111011111111', '11100111110111011101001011111111', '01111011111001001111101111111101', '10001110101110111101110111111111', '11110101111101010110001111111111', '01010110110011110111111111011111', '10111011110110111011001011111111', '11101101101111101101100011111111', '01011101011011111111011001111111', '10110001111011011110110111111111', '00111001100111111111111111110110', '01100011110111110101111111111011', '10110111101111100111001011111111', '11011110010011101110101111111111', '11011110011100101101011111111111', '01101111001111010110111110111111', '10001101011110111011011111111111', '11101000111011101110111011111111', '11110110111101100011010111111111', '01100101111100110111111111011111', '10011111110001010110111111111111', '11111010100100111111010111111111', '00110101101011111111111110101111', '11001010011011111001111111111111', '00110110011011111111111111110110', '00111001011011111111111111111001', '11010001111010111011111011111111', '11001111100101011111110011111111', '01010110001111111101111101111111', '10111101101110110001111011111111', '11101011011110110010111011111111', '01101010111100111101111111101111', '10010110111111110110100111111111', '00001111111111111111111100001111', '11110011100101011100111111111111', '01010011101011111111111111111010', '10111101101101001110111011111111', '01100101001111111111011111111101', '10011111111110010101001111111111', '11111010011011001111010111111111', '00110101010111111111111101011111', '11001001010111111111101011111111', '00111111001111111111111110011010', '11011011101110111000011111111111', '11100111010010111011101111111111', '00111100111111110011001111111111', '11010010011111100111111011111111', '00101110101111101110101111111111', '11000101111110011111100111111111', '11101000110111011101110111111111', '00111111011001011111110011111111', '11011011110100101110111011111111', 
             '11100111011110000111011111111111', '00011011111011011011011111111111', '11110101110001101010111111111111', '00110011111111111100001111111111', '11001111100110101111001111111111', '00011110011111101011110111111111', '11110000111111111111000011111111', '00101110111010111011111011111111', '11010111101101111101000111111111', '11111001101011001001111111111111', '00011110101111010111111011111111', '11110011001111110110010111111111', '00101101111001111110011111111111', '11011101010011011011110111111111', '11100111101110111011010011111111', '11111010010111111100011011111111', '01110111100011101101101111111111', '10001011110101111101011111111111', '00111100111111111100110011111111', '11011110101100011110101111111111', '11100010111010110111110111111111', '00111111011010101111001111111111', '11011011110111010001111011111111', '11110110110001011111100111111111', '00101101011111100111111011111111', '11001001111101011010111111111111', '11110110010111001001111111111111', '00111111100110101111110011111111', '11011101110110110010101111111111', '11110011011010101100111111111111', '00101011110111011110111011111111', '11011101111001110001011111111111', '11110110001101011111011011111111', '00100111110111101011011111111111', '11011011101110110111100011111111', '00111111101001100011111111111111', '11001111111111000110101011111111', '11111010001101101010111111111111', '11100111111011101110000111111111', '00010111110111011101110111111111', '11111001111110010011010111111111', '00011110111001111101101111111111', '11111001100111110101001111111111', '11100111101110110100101111111111', '00101011011101111011101111111111', '11010111010001111101111011111111', '00011101101111101101011111111111', '11111001111101100011101011111111', '11110101011011001111101011111111', '00111111010110010011111111111111', '11000110111110101010111111111111', '11101011010001111110110111111111', '00110011111111110011110011111111', '11011101001010111101101111111111', '00011101011111011110101111111111', '11110110111110011100010111111111', '11101000011101110111011111111111', '00100111101101111101111011111111', '11001111111111001001010111111111', '11111010101011110011011011111111', '01110111110101000111111011111111', '10111101100001111101110111111111', '11011110111010110100111011111111', '11111001110010101111100111111111', '01111110101110110010110111111111', '10110111001001111110101111111111', '11011011011101111011010011111111', 
             '01110001110111011011101111111111', '10001110111011100111011111111111', '01111110011110001110111011111111', '10100110110011111100111111111111', '11001111001111111010100111111111', '11101011110100010111101111111111', '00011011011110111101111011111111', '11100100110111100111101111111111', '01110111101100101110011111111111', '10111101011101110010110111111111', '11011101100011100111111011111111', '11101011011101001101111011111111', '00001111111111111111000011111111', '11110000111111110000111111111111', '00101101101111011011110111111111', '11010111110100011011011111111111', '11101011100010111101111011111111', '01110111001010110111111011111111', '10111110011101000111101111111111', '11011110110110000111110111111111', '11101011101101111110001011111111', '00101110011111011101011111111111', '11010100111011101101110111111111', '11101000101110111011101111111111', '00111111110011111010100111111111', '11000110010111111111010111111111', '11111010010111110011100111111111', '01111110111000010111011111111111', '10110111100011011011111011111111', '11001100111111111100001111111111', '11111010110001100101111111111111', '00111111111100111001010111111111', '11010111101101110010111011111111', '01001011011111101110011111111111', '10110111011100101011111011111111', '01001011101111011101101111111111', '10110111111010111101100011111111', '00011101110101111011111011111111', '11110011111111001010011011111111', '01111011001001111101011111111111', '10110100101111011101101111111111', '11011000011110111110110111111111', '01101111011011110011010111111111', '10110111000110111101011111111111', '11001111011001011111001111111111', '00111111111100110110101011111111', '11000101100111111001111111111111', '01110111111010001011110111111111', '10111110000111011110110111111111', '11011011101101000111011111111111', '01111101110111101110001011111111', '10110111111010110010011111111111', '11001111010110011100111111111111', '01111000111001111011110111111111', '10100110111111001111110011111111', '11011101101111010100110111111111', '00101011111011101101110111111111', '11010111011110110001110111111111', '01110001011101111110111011111111', '10111101110100100111011111111111', '11001100110000111111111111111111', '01111101101110000111101111111111', '10111110111011011110001011111111', '11010111110111101011100011111111', '00111111110011110101011011111111', '11000101011011110110111111111111', '00011011101101111110110111111111', 
             '11110110111101101100101011111111', '01001110101101111011011111111111', '10111101000111101011101111111111', '11110110100111110101110011111111', '01110010011110111011011111111111', '10101001111111001111001111111111', '11011110001001110111110111111111', '01111101000111011101111011111111', '10111101111000011011101111111111', '11000011110011001111111111111111', '01111110111011101000011111111111', '10110010101110111110111011111111', '11011011110111011110000111111111', '01111011011100100111110111111111', '10101111101011110110110011111111', '11001111001111110101011011111111', '11100100101101111110110111111111', '00111111010101101100111111111111', '11010111111000100111101111111111', '01111000110110110111111011111111', '10111101111011101011010011111111', '11010001011111011101011111111111', '00101101110110111101101111111111', '11010111000111010111101111111111', '01111110011101111110000111111111', '10011111111110011010110011111111', '11100111111011100001111011111111', '01111101100010111011011111111111', '10111011101100101101101111111111', '11001010111110011111011011111111', '11110011111111000101100111111111', '01111011011111011000110111111111', '10101111010111110110001111111111', '11010111100010111110110111111111', '01001101111011101011101111111111', '10101100011011111111100111111111', '11110011111100110101011011111111', '01111110110100101011101111111111', '10101111001101101111010111111111', '11011101011100010111111011111111', '11110000000011111111111111111111', '00100111111011010111101111111111', '11011110100011011101011111111111', '01111011110101110010011111111111', '10101111010111111001110011111111', '11011101101111011011001011111111', '11100001011111101011110111111111', '00010111111011101110111011111111', '01110100011111010111110111111111', '10111110011110111000101111111111', '11011000101101111101111011111111', '00001111111100001111111111111111', '11100111100001110111011111111111', '01111101101101111000101111111111', '10111011011111100001011111111111', '11001010100111110110111111111111', '11110110111110010011101011111111', '00011101111010110111110111111111', '11110000111100001111111111111111', '01110111010011011110011111111111', '10111011101111011101010011111111', '11011101110110111101010011111111'],
 
    #min Hamming dist=10, r=0.5, column sum  499 and max 501, avgHammingDist=16.01
    '16/32':['00000000000000001111111111111111', '00000000011111011110011010011101', '11111111100001110100100001000010', '00000001011111111011000011100011', '10011110111100100001001100011100', '01100000001010110110100110110111', '00000001110110111000101110010111', '11111111011000001110011001000000', '00000010101110100111111011010100', '10100111110110011001010000101001', '01011000100111010110100010111010', '00011101100001101000101101001111', '11100000010000111111001001011110', '00000010111001111000010111111001', '11111101101100000100110001100001', '00000011100101110111001100101101', '00011100011111000011101101100010', '01111101010010000001110100111010', '10000100110101010101111001100101', '11100010000111100111010000100111', '11111011101001100001010111000000', '11001110000011011010111010010100', '00110000010011110101110001111001', '00000011101001011011111000110110', '00011110001110101110001110010010', '11100001001100100010010111011110', '00001110011110001101001011101001', '11110000101011010010100101001101', '11111111011100010000001000111000', '00000111110011100101110100001110', '11111001000110011100100111010000', '01011011011000100010011010100111', '10100100000100111100111100001111', '00111110010001001011000101111001', '11000000101100010011101010011111', '00000111101101110001101011001010', '00110011100000101110010111110100', '11001000011000010101111110110100', '00111010000110100100010111101011', '11000100000110101000111011111010', '10010011111001001111000110000011', '01101100000110101111100010011001', '11101000111010010010001001100111', '00010101100011011011010010001111', '00011101111011101100011000100100', '11100001001101011011111110000000', '00001111000111011100100001111100', '11110001110110000101011110100000', '10001100110011011011100001010011', '01110010000111101000101000011111', '00011111100001100101000010111011', '11100011010100000110100100111101', '11110101011011101010000010000110', '00001101101110010001011111110000', '01100110011001011101011100001100', '10011000010100111111000111100100', '01100101110010101010111101000010', '10011010011001100100111000111010', '11111110100010110011010000001001', '00001100011110111001110001001110', '11110110110000010110000111010001', '00110111101101001000000101110101', '11001100101101001100000101111010', '10101011100011000011011110000101', '01010011010001110100111111000100', '11111000011000111010100010100011', '10011111010111000001001001011010', 
             '01100010101100101100101101101001', '11111001101111011001100000000100', '00010111011011010010101000101101', '00010100001101100110010100111111', '11101100111000000111111010000010', '00100010100111111010011110100010', '11101011110000000000010101011111', '11111101000001010011000111010100', '01010011011110011000110001011001', '10101000111010101101101110010000', '00101000011110110010101111001001', '11010101100001101100000011010111', '01001110110010101011000000111110', '11010111000000010101011110100110', '00101011111101001010001110011000', '10010000001001101111110001110011', '01011110100111000001100111000101', '11100101011010011100010000110101', '01010110011010100111110110000001', '00111011110100001100100011001110', '10001110000010110011011101100011', '00111101000101001110110110000011', '11000001110011011011001010111000', '00010010111100010101011001001111', '10111010101010100001100100110110', '01001001011001011101100100101011', '10011010100100110010011001111100', '01100111000010000110011001111110', '11101101010101101100110100001000', '01010100110101011001010011110010', '10111001001110100000101010011101', '10101001111011110000011101100000', '10110100001100011001001110110011', '01001110100101100110101111000010', '00000101010000111110101011111001', '10001010101111000010110001101011', '11100011001011110101000100011100', '11110100111000001001010010011101', '10001100101001101011001011100110', '11110011000110110100111000000101', '00011010100100101111110100001101', '01000111011111000010101010110010', '10100010000001110001110111101110', '01110101110111111100000001000001', '10010100110010011111011100010100', '01101011000101010101101011001001', '00100111011011011110100101010000', '01011100101000011010011100111010', '00101001100001000111111101011010', '00011111100110111010100010100100', '11000001011011100000001110101111', '00110011010101111001100110010010', '11100110101100000110000011001111', '00111000011011000111100011011100', '11010111111000100000011100110001', '01000011110010000010111111101001', '10011100010111111101000000010110', '01010110000111000101011101110001', '10111001011010001000111011101000', '01011001110001100111110000110100', '00100110100010001101010111100111', '10001101001100010110110011100110', '01111010010101011001001101000011', '10010100001011110001111101011000', '01001001110110011101001000001111', '10100001001010111011101001010101', '11100000111100111000010110010011', 
             '01100111100101000101110010010110', '00011000111001110100001111100011', '10010111100010011110001001001011', '11011000010111001000110110100101', '00101101101001111010010000111001', '10101110010010100100001110011110', '01001100001111011010011101000101', '10101011010000110011010010111010', '01010011011101001101000010110101', '01111110000110100101101001001100', '10110010101110101010100011011000', '01001111000100110101010101000111', '11010101101100001110001110101000', '10101000111101100011110000100101', '11000110111010111100100000001101', '11100010001110100011101101100010', '11011010000010001111110011100010', '01100000110001010010101110111101', '10111101110000100010011001011010', '00001011001101101100101110100110', '00011110101010010101100100111001', '00110100111011010000010111011010', '01110000100101111001011001010101', '10011111001010000010010100011111', '00011110111100001001110110100010', '10100001111110001001001011010110', '11001010000111111010100100110001', '01100101100001110111001010001011', '00110010001011010001111010010111', '00100001111100111111011000100100', '11000001101010011100110011011010', '11000110010011010011100111101000', '01101000011101100000101001111110', '10111101011001010111000000001101', '11000011110000101101111000101010', '10010011110101001010010111101000', '10001010011000011011101101011010', '01111100010100110111001100000101', '00100110100011001110101000111011', '11010001111100100101000001100111', '00110101000010110010110111101100', '11001011101101001010000011110001', '00000100110111100011010111001101', '01111100000011011100001100010111', '11111001000100100110010010110101', '01110001001000011101010111111000', '00001101010101110100011010110011', '10110011111110001110101000000010', '00101110010100101111010101010010', '11101000010011111001111000001001', '01010001100011000001011111011110', '11110111001001100000101100101100', '11011110101110000000101101101000', '01100010011010110011010011110100', '10001101100111101100110001010001', '01110010111011100011101010001000', '10011100001101010100000111010111', '00110011000100011011111001001110', '11101100100001010101100110101001', '10010110010000110110110010110110', '00001001111111001100000101100111', '01011011101011000100110010101100', '00101010110010111011001100010011', '10010101010100001001111101010110', '11000100011110101011011010001001', '00010110100000110010001111011111', '10001111011001000001101010010111', 
             '01100000100110111111000111101000', '00001111010011011110010100101010', '11110011101111000010001100100001', '00101001000101010011110100110111', '11100011011110101100100001010100', '00101101100100101001110011101100', '11010000001110010110111001111000', '00110101011110101100101100100001', '11001110111001000000011111000101', '00111010011010101010011001001101', '10010010001100110111100110001011', '01000011111101100100100110011001', '11011100110001011110001000100011', '10110011000001011101101011110000', '11111100100100111010010101000010', '01101110100011010001101001010110', '10000101111010110001000110011011', '01001001010001101100010101111101', '11011000001011100111011001000110', '00111110100111010000001010111001', '00010100111001101010100101111100', '10001011110000000111011011110001', '11101010100111001000110010001110', '10101000101011011101010000011011', '01000111001101001001111000101011', '00111110010110000010110101110100', '01000011101011110101011010110000', '01011100001100011111101001000011', '10100111000000111110000110100111', '00100101010111100101101011000110', '11011001111000011010100101000110', '11111001000101110000000110001111', '01010000010110111101110010011100', '11000111110110000111001101001000', '00111111011101010100010011100000', '10100010111110111110000100110000', '11001101001010100011001101111000', '00001010011101010111001101110100', '01110000101011001000111010101011', '00100111001110000011101110011001', '01110100110001100110110000011011', '10011101000000101001110110100111', '10000110101000011100101001110111', '10101001010111100011010001001110', '11010010110010011000000110111011', '10111000101101010111110011000000', '11000110100000100111110101010101', '00011001110100101000011110101110', '01101011111001000110001000010111', '01110101001111001001001111000100', '10011001101100111101011100010000', '00101000110110100110000011110111', '11000101010000110000111101101101', '00110000110011011111100101100010', '11000111001010001011101010101100', '00110111101000101101011010000101', '01111000010111110000110101001010', '11010111101101010000010010011001', '10010010010111000000101111001111', '10101001001001111110100001101100', '11101100001011111100001010110000', '00000110010010011011110110110011', '11001010011110101001011100100100', '01110101100100110001100011010011', '00011011000111101011001010011100', '10101101110100010100101101010001', '01001010001010001110110110011011', 
             '10111010011101110010101000000110', '01000110111011000001010011101110', '11110000100000101110101110010110', '01011110001011101110010000111000', '01100101101010010001110101101001', '01011111010101100011010001010001', '10100001101111110111000000101010', '00111010010000001101101100101111', '11000001110101010110011001011010', '01101101001100000100011110001111', '10110110010010111011100100100100', '01110110110010101000110011100001', '10010001101101010000001111111010', '00110001100110011111000110010101', '10000110111001111011011000001010', '01001001000011110010111011110001', '10100100010001000101110111011011', '00001110101011110100011101001100', '01101100011100001101100001110101', '10010000110110010110110000101111', '10000111001101101011001100110010', '11011101001110010011000110100001', '01011011110001101000010011011010', '00100101011001101000011010111110', '10110010001100001110111101010001', '01011100110111011010000001101100', '11000010100001011111000111001110', '10111100110010110100111010000100', '01110011100000000101101011100111', '11101100010110001010001110110010', '10011011100001010001110100011101', '00010001101111100110011110001001', '10001111011010111100100000110010', '01100001101111000111010101010100', '11010100100101000011111100111000', '10111110000010101000101111000011', '01001011111110110010110001100000', '10101011000101101101000011000111', '01001110011000110001001011111010', '10110000001110100001010111110101', '11110101000001101101001100011001', '00011101111101011000100010001101', '01101010011100010111100100001110', '01011001010010011110001011100110', '00101110110111100010111100000001', '10100010101011000110011011101100', '01101010000001111001110010110011', '01110010100000110001011100111011', '10010111011101001110100001100100', '01011001011000000101001111011101', '11000100101110011011100111000010', '00100100111111110000100001110011', '10001011101100011100010010111100', '00001001100010111111110101000110', '01110111000000001111110000011101', '11001011010011101110011110000000', '01000100011101010110010111101001', '10110010001010101001001001111011', '01111101110111100001001000010100', '10100101001010000101100111110110', '10101100100100111011100100011100', '11110001011001011000011001100011', '01010110110110001100111000001011', '11001111100110010100001010100011', '01110000010001101110100011101101', '00101000011101100011011011010011', '00000001010111001101111101101100', 
             '01110001001011110011011100010010', '10100111110011001000110011010100', '11001000111100100010100110111010', '01010110001110111000010110101010', '00101110111001100001100001011101', '11010000010110110101001111000011', '10101101001001001011101100001011', '00110110111101011011000010000110', '10011111110011010101000010100100', '01011011001000111100100100110101', '01011001100100110010111000011011', '11001000010011000111000101111011', '10001101000010011100101110011101', '00101011101100110110110110000010', '10110110100101000000111001011101', '11100100010111000101010010111100', '01010011101000110110011001101010', '10111000110010001011111101000001', '01010110001001101001111001110100', '10101011100000011010001011101110', '01101000001011000111111100100101', '11010110110110110011100010010000', '00110011111110100000001111100100', '00001010111101101100010000011111', '10010111010101010111110100000001', '11001101001101111000001001001110', '10110101011010100101010101001010', '01000100101101011111100010110001', '00101001110010100100111001101011', '11110011000010011010001110110100', '01111010100111001111001100001000', '10001010110000110010110110101101', '01110100011110010100000001011111', '00001011101000101011010011010111', '11101110110000011001000101110100', '10010110010101111000101011100010', '10010000101101111000110101000111', '10011100000011000111011110110010', '10001011001011011011000111001001', '01101101100000010100101011111010', '01000011011010101111101000000111', '10000101101011100000110110111100', '00110000010100101011101010110111', '01101010010110010110010101011001', '01111101101010001110100010010100', '10110100000111110100011010011010', '01100110111000110111000100100011', '10010001000111001001011011101011', '10100010011001110111101000110001', '10100010010110011111001011000101', '00001010101000101000111101111110', '11011111101000001001100001010011', '01010000110111100010111011100100', '00001101111000100110101110001110', '01111011110001011100010100010001', '00010111110100110110000101111000', '11001110000101100001011000011111', '01011000111011001011010110000110', '10101101000101100110101010101001', '00100100011110011000111110100110', '01001010101101011101110101001000', '10010101101010000010001011110111', '10011001001100100101110101101100', '01100011001110101101010010011010', '11110110011011010100101011000000', '10110011110001101001010000111100', '11110100010101010000100101100111', 
             '10001010001110110100101001011011', '01111101100010010011001100101100', '11110101010010011010010101001001', '10100011011111101000100100001011', '01011100101001000111010011011010', '00100100100001101111111011110000', '10011111010110001011010010000101', '01000101011100111110011100011000', '00001000111101110101111010101000', '11000111100111001010000101000111', '00100011110001110100001011011101', '01011110001101000010011110110100', '01010000001110101011100101011011', '10111001110000010101010101100011', '11101000000110010000110001111111', '00010110101011111001001110010001', '11101111100001000111000100100110', '00011100000100010111111011011100', '00010010110011110111010001010110', '01110111111100111000100100000100', '10000101110111100100101100110010', '00110011001011001011110101000011', '11101110000111100010000011101010', '11011000100001001010011011101101', '11010101101110000101100010001110', '11100011000000101001011110101101', '01011110010010110000000111101101', '10001001111001011000111110000011', '00111001000001111111001000111010', '00101011011100011000100111110100', '11001100111100011001011000110001', '00110010111111001101110000100100', '01010001011101000111011000101110', '01101101111010011100000111000010', '10001111000001010010110011011011', '10111000111100001100001101101100', '00100111100010110100110111010001', '10011000010111101110101100001010', '01010010000100011100110011110111', '01001011010010010011101100110101', '10100000101001100111001101010111', '01001010111111000001101000111001', '10110110001010110011001010001110', '11111101001001110010110010001000', '11000001010010101111110101110000', '00101110100000011111011010011001', '01010001011111101000100111110000', '10100100111001001100110100101101', '10011001110110010011101011000010', '01100110101010100000011011010111', '01101101000111011001000000111011', '11000100000101101111101001001101', '11110110010000101100010111001100', '10011010101011000110101010010011', '00100111001110110001010100110011', '11001110010010000100111001100111', '00111100101011100100100011100110', '00000011110101010110100111100011', '10110100011101000010001110011101', '01000011111000111001001100111100', '01111001011000110100101101010010', '11110101000110111011010000010100', '11101000101100011011010001001101', '10110011100111010000110100101010', '01101001110101101111001011000000', '11001011101001100111110000001001', '00011110010110100011011110101000', 
             '11100110110010001101100100011010', '00011000100001011101011010110111', '01111011001011010010000001110101', '10010001011100101010011000011111', '10001110011100100110000111110001', '00001110110010111000101111110000', '01000101001111111100010010000111', '00110000100101010011011111101100', '11000011001001000001100101111111', '11100001110100110011110100001010', '10010100100110101100101000111101', '10001111001011010101111110000000', '01111010101100101001000011101010', '11101100000000011110110111000101', '10010001110011110011001001100101', '00110101010011001111111000010010', '11101010001101101000111011000001', '00010100011010001101011100111011', '11000110111100011010001011010100', '01100011110111110110000110000100', '10111110100010001000011100101110', '00011101000110110011100001111010', '01010101010000011011111010100101', '11111010011111000100100100011000', '10110000111101001001110001011010', '00101111001000110110001110111000', '11000110101001101100100110100011', '01011001010011100010000111010111', '01110010011100010000111110001101', '00001001110110001101010011111010', '01101111101100010001111000100100', '00110101000011110001000101011111', '10000101011111001111000100011100', '00100011111101000011010010101011', '10011010100000111110111111000000', '01101000100011111100100001110101', '10010100101101110010011010100011', '11101111010000100101101100000011', '10010010011011001000011101110101', '00111001100010111001100010011110', '01110000001101011110001111010010', '10010011111010011101000001011100', '01101110100100001010100010110111', '10101100011101010101001001101010', '11000101000110100110110110001101', '00011011110011100001010101101001', '01000100100100111110111001100110', '11101000001011000010101111011010', '10100010010111010011111101010000', '01011111001101110110001000100001', '01001010111010001110100101101100', '10110001111001110100110010110000', '01111101100000000011011111000011', '11011100010010010001011010011011', '00000010001011101111010110101101', '10111110100100001101001001010110', '00011001011010110111011011000001', '00001101101111011010101100010010', '11000101110101101001010010001110', '10011010000111010011001000101111', '01110111101010100000100010111010', '11001010110001011101100010010101', '00110111010010100010001101101011', '11010011100100011111100000101100', '10100001010011100000111101010111', '11110100101010000101001011101001', '00000110001100101100110111011101', 
             '01101101010110111000010101100100', '00100101101100001110011100110011', '11111010001000011111010010010100', '00010011110101101101101001000011', '01101100011111100010010110011000', '10010110101011101010110000010110', '11001001110110010100100101101010', '00111000010101010100111100111100', '00100111001001101010101011100011', '11001110000110111101011011000000', '11000100010001111001000110111101', '01111011010100000001111011010010', '10100001111000101110000110011101', '00110100101110110111110000001100', '00110101110001010101100111001100', '11011001001010100001111000101011', '00111101000000101111101101100100', '11000010110011100010001011110011', '10110111011001010001010001010110', '01001100110101101010001101110001', '11000001011101011100101000110110', '00101110001111001001010100001111', '11101010001000111100011100100011', '00011001101010010111010110101010', '01010100100011111010101011011000', '11000011011110000101110100100011', '00010110101001001111001101101010', '10001001010100110001100011110111', '00110110110110000110011010011100', '00101000111001011010110011010101', '11000001011010010011011111001100', '11001011000110001100000111101101', '00011111110011000110101001110000', '11110110000100101001100110010101', '00110110110100010011001001110011', '11001011011101110001001110001000', '01001010101101110010010101010110', '10100001011011010110110001001011', '01100110000011100101111110101000', '10011001101011101010000010101011', '00111011010110111111100000000001', '11110000101001010100000010111111', '01001011010011001011011001001011', '11000100111110010000110100011110', '01010011101110000111000011010011', '01010100100001110100010111111100', '10101101100000011010110110110010', '01011000011100101100111101000101', '11111110001010010110100000101010', '10110101100100101000001111011100', '01101101011000111011100001011000', '10100000100011101101111010000111', '10011001001110001011000101110110', '00000010100111010101101110011011', '00011111000101011100011110001100', '10100100010110111010010011110001', '10101100101111100000001101001011', '01011010111001010101100001100110', '10011100110101001111100110010000', '01101111111010001010001000101001', '10001010010001111100011011010110', '00110110101101100011100100101001', '01001000100110000111011001111101', '00010110010111101001000110100111', '11100011101010101011110100000100', '10100111000101100100010101111100', '01110100011000000011101111110100', 
             '10011010011010110100010010001111', '01100111110001001001111110000001', '11001101110111010010101000001001', '00110011000110101100111001110010', '11111001100000110011100100110001', '11110001000100111100001011101001', '10010100001001001011110111001110', '01101100011000010010111100010111', '11001000101111000001011010110110', '01000011010011111101000001101110', '10100000001011111010001100111110', '01001110001011110111000010010110', '00111001110101000010110001111001', '11000110110100100101001010101101', '00110001111100011100111111000000', '10111011111000000100111100000101', '10010001001011001101100110111001', '11000101001001001111011010010101', '01001010100101110000100011101111', '10100110110000110101111001011000', '00011000001111110101110110010010', '00101001110110011010111100001100', '01011110000000101111000011001111', '11010101001010111000101100010011', '00100010010101111110010101100101', '00001110101110011010010011011010', '11110001110010000110100010110011', '11100110100101111001110001100000', '01111011110100000011011000001101', '10000111001100010011011011101001', '11110100001110101100001001100110', '00111011011010101001010110010100', '00111111111001010010000100110010', '11010010010000011111001101101001', '00111000100111000100110101010111', '11110000101011001010010111110000', '01000101110101010001001101101011', '10001000111010100001110111100011', '01101101010100101110101000010110', '00000101011100001111100010101111', '11001001100111000100111111000100', '01010011001010110001101011001101', '01001111100110101100001100111000', '10001101101001001001111001111000', '10101110001110010010111010000011', '00110001111011111001001001001010', '10010010110111111000011000010011', '00010011010110000111010111001110', '11101100101011100010101010000101', '10010101001000111101010000111110', '01111111010011001000100101001100', '01011110110101110101010000001010', '10100000011000100110111111111000', '01111101001011100101100001010001', '10010111100001011010101100110001', '01100110000111011110110100000110', '11011010010100001010100011111100', '10011000101010110011000111011100', '00101001111100101001100100110011', '00010101101111010101010100100101', '11100100010001110100011111100010', '10100010010101001001011110011110', '11101010010010110110001010101001', '11111011010001000100000011110110', '10110100000011011110000001111101', '00110101111000100011010101010101', '01011011000101010101101100010110', 
             '10001111011110001000011111000010', '01000110100110100011111010100011', '11000000110101111100101010001011', '10111101101010010110011000010001', '01000101111110000101111001010010', '01011011000100111011010101101000', '00011110010111100110100011001001', '00100011101110110010000010111101', '01010100001000110111101000111101', '10111000110001011011001110001010', '11000001101110110110001100010110', '01100100111001101000000111001111', '00101010101010011100101110101010', '11001110011101100000110010100110', '10010011001101110111001011000100', '00101000010011001010110101101111', '11110011000000110010100001011111', '10011010101111111011010000100000', '11101010101110001101000100010101', '00000100011011011111110011100100', '10000101110100101100010101101011', '11101010100000100011111010011100', '01100000111011000101010110110011', '10111101010101000001111000100011', '00100011110010010001011101110110', '00011011001101111000101101011000', '01011100110100111110010010010001', '11000100011011001101101110000110', '10011011001010110000011011110010', '01110111000100000011000111101101', '10110011100011101100100101100001', '01011110011000010100110111011000', '10011011110100010000001110110101', '01100000001111101010011001111001', '00001110000110001011101111001110', '01101100101001011011100000101110', '10100110111001001111000010111000', '01110001100010001100101101011011', '00101101010011100001001011111001', '11011111010100011100110000000110', '11010010010101110010111001001001', '11110000100110111001000010100111', '00001101111111000110110101001000', '01110010111000101010110100110010', '00101110100101100001010110110101', '10010101011000011101001011000111', '01001001001011110010110100001111', '11000010101100000110111110100101', '11101101010001000101101001011100', '10101011110000100011101101101000', '00011101011011011110000010010011', '10010111000110100010101101010101', '01100000000101011101111001111010', '01010000010111010011010100111101', '11111000110010101110001001110000', '11010111111100100010000111000010', '10011010101101000101000110101110', '00100101011100111101010011001001', '11101011100011011100011000100100', '00110100101000010110111110001011', '00001011100010101110101011001101', '11101110011011001001011000010010', '00100100010101110011111000011110', '00110001101010011000110001110111', '00001111001100011101100110010011', '11110111010011100111000000101000', '11010100101011010001100011110100', 
             '00101101010010100111010110100110', '11011010101001010000111011001010', '00000110010111111010000101011011', '00000000101101101101111100110101', '11001111101100100101101010010000', '11111010101001101000000100111001', '01011100010001001110011101001110', '10100101011111010001100111000001', '10010011000100000111011100111011', '01101101100010111011000011000101', '11010001010101001010110011010011', '00111001001010110001001110100111', '10000110111001110110100111000100', '01100100101100100101100101011110', '00001000110111001010111010110011', '00001101111010000001111010101101', '01110011010101101010001001100110', '10010000100110011001110111111000', '00001111011001101010011100010101', '11100011100010110101001001010011', '00110000011100110110001110101110', '11111001011100101101000110000010', '01111010100110011010011001100001', '10001100010000111111110010001011', '01110001101110001100011000111100', '10110111100001100011100010000111', '11001010110011010100010011111000', '01011001011100001011111100110000', '11000110001011011100011001101010', '01010111111001000011001001011100', '10101110000011110100110100100101', '00001001110111111011010110010000', '10100100110010010010101111001110', '01001101000000111000110111011110', '00100100001111000100101101111101', '10011110001100001000111010101101', '11010011011011011011100000010010', '00100110001111010111000111100010', '01011010110010100101111100011000', '10100000110111100111011000011001', '11111000010110001101110000010011', '11000111000100110010101110101010', '00111010101010011111000001000111', '01100011111001110000110000011110', '10111010010001010000011111101001', '01111000000111100011101110110000', '10000111010001011100010011101101', '11010100100100011111000100011011', '00011111001001100110110001001110', '00101111101111000100001011000101', '01011100010010101101001010110101', '10001000101110010111101101000101', '01110101001101011000110100011010', '10100000011100111001100101101101', '11000101110000100110001111110100', '00001010101000111111100011111000', '10101111101111101000000000100110', '01010110111100101111010001000100', '00101011010010010000111110011011', '11010000111101110000101110010100', '00110101100111101001011100101000', '11001000011001111011010101000011', '00001110000101001110111001010111', '11110001011000110110010101100100', '10111000100011000001100011111011', '01000101011010010110001101110011', '00011011000011101101111010100001', 
             '11100001101001101110011100001010', '01110110010100011001100000111110', '10100110101001010000011110110110', '11101001110110001010000011001011', '00010111111011001000101110001010', '11011000010111010110001001010101', '01111011100110110000010011000110', '11011101100000100001010001111101', '01101001111011001000101100110100', '10100011001110011001100011101010', '01110000011111010101101000100011', '00001101101001110011100101100011', '10100011010100101111101010011000', '10011110001000100101011011011001', '10000011110101100010010100110111', '01110100100011001110000110101110', '01001100101110101101010110001100', '10010111000000111011010110011001', '00010101110100010111101100100110', '10001100011011100110010001101101', '11100110011100100110010000111010', '11001010100010010001111111010001', '10110101110011110010100100011000', '10110011001101000000111011100110', '01011000101101101110100000100111', '01000111010010011101101011010100', '00101000000001111100101111011011', '00111101011110010101001110001000', '01100010000101000010110111111011', '11101010111000110101001011000100', '01111001001101001101010001001011', '00100101100100010010111011110101', '10011011110010101110000100100110', '00011010100011011001101101101100', '11000000111000101010111001110101', '10111110000101110110000100011001', '01000100110011110001011100010111', '10010110010110001011100001101011', '01010001111100110001010110101001', '11110110001101001010011000000111', '00101011111011000101110011000010', '10101010001110000111110110110000', '01011011111001011110101010000000', '11011100100010111001001001101010', '01101110011110100011000001000111', '11110001000011011000110010011101', '11010111001110001100010110010100', '10001101000101110111011101001000', '10101000110100101000101011111001', '10111001111100110100000000011110', '01010111000000001110111101100011', '01110000001110100110111011000011', '01100101101001100100111000100111', '10100110000011101011000111010110', '10011100011110011000001101011001', '00010011000011010111110110110100', '10001111110001111000101000011100', '01111110000010001001010011111100', '01011000110101001101000111101001', '00000110001110010101011010111110', '11100101111100001111100100000001', '10111000010100000011110110001111', '10111110001101101101101100000000', '01101010001011101000001111101100', '00110111101000011011110011010000', '01000011100111010100010000111111', '01011000111000111001111010010010', 
             '00101111010111010010000010100111', '11010101000011100001101111100010', '11000010111100111010000001101011', '10000111110010010110100100010111', '00111001001001100110011101110001', '11011100111111000100011010001000', '00000001100110100101100111111101', '11100010110011111010001101001000', '01000111101111101010011011000000', '01100101011101010110100010011100', '10011000010010011100110101110110', '00111100101100010001010000111111', '10110001000001100111000111101011', '11001011010101001111101000100001', '01110010111000000001100111011011', '10000101011111110000001011110100', '00011110000010111000110000111111', '10010000110111100011000010111110', '01101001100010101100011110010101', '00110000100111110110001001001111', '01000010111000011001111101100011', '11001010011110001110001000011110', '00110010110001100111011111000001', '10001111111000000010100001111110', '11010101000111101010111000100001', '01101011100100011011101101010000', '01111010001001100100110110000111', '10000110101010111101010101010010', '01111100011001000011011010101001', '11011111011010110010001100000100', '10001001100101001001100111011110', '10110100011110011111010000100010', '10101011000110011001010101011100', '01001011101011100100100101110010', '00111111010000010110101011000101', '01010100100101110011110110000110', '10101101001110001000110100111001', '10100011110010100010111010100110', '10010000010101101100011110111001', '01001000100100110101011111011010', '10010000111001011011100011101001', '11100111100000001001011011110010', '01101100100011010100010011001111', '00011101010010101011100100011101', '01110100011101110101010101010000', '00000000111011111111101100001100', '11010010011001011001001010101110', '11100011010101000100011111010001', '01111111000100101100100000101011', '00011001111111001001011001010001', '10100111001110010110101100100100', '00101011001010100111100010101011', '11000111101001010100101101011000', '01001111010100000101110110101100', '10101110001101011011001001010001', '01100000110100001101111011001101', '11001101011001000010010110110011', '00010010001111110010100011110110', '11010001110010111111010000000011', '01111001001101001010000010111110', '11111000110000110000101100101110', '10010110100111000110010101011010', '01100110000010111001111101000101', '10111100001001001100111011010100', '10001010100010111101001110100101', '00001100001001111010111111101000', '00100101110110001011001101100101', 
             '10000110001111011000100010011111', '01111001111100100010100011000101', '00110111011000110100011000011011', '11001100100011011111010101100000', '00110111010000001010111110111000', '11000000110010101011100110001111', '01011000111011110000010001011101', '11101011000110000101101000111010', '01010010010001110110001100110111', '10110011011100101011010001100001', '01000010111111011010110110000001', '10101101100000110101010011010110', '01111101100001111001101010100000', '10110011010110010100001001101110', '01001100010110100100110111010011', '11001101101101100001001100100101', '00000001010011011101010111010111', '10111100101000101111010001101000', '01110100010010110111000110011010', '11100110101100110010011100001100', '01011110011111001000000001110011', '11000101111001100001110011010001', '00100011101001011001000110011111', '00011101101110110100000011001011', '10111000101000011110111000100110', '11000010110111010010101100100110', '00101000011010101011111000111010', '10111111100111000110100000001100', '10010111100110010101111000110000', '10011011000001001110001101111100', '01100011011111100001011010000101', '01110110000110010000101111110010', '00110110000111001101110011001010', '10011000001000011110001011111011', '01000011011001100111010101011010', '10001101111001101101001010001001', '01010000101100101000001111110111', '10111010000001011111110100101000', '01010110101010010110010010100111', '01100000110111101011100001011100', '10001011010100100110111101000110', '00110000111110011001101010011001', '10001011000111101000010110111010', '11001101110100110111100001000100', '00110101100001011100111001101001', '00111010111111100000000110010011', '11000000001101111100110110101100', '01101110110000110010110011001010', '10001011111101010001000101010011', '11010011010000110101100010111001', '00111101001011010011111001000100', '01011001111110000010001101011010', '10101101001000100011011000110111', '00011010110110000111101010100101', '11100100011101001000111101110000', '01110111100011010001000110100011', '10101110111000011001110000000111', '11001101000110001111011100000110', '00010010010101011101100101011101', '11101101010010100010100010111100', '11010011001011101000010001001111', '01100100001101101110001110100101'],

    
    #min Hamming dist=6, r=0.75, min column sum  249 and max  251, avgHammingDist=12.01
    '8/32':['01101010000001000101000000000010', '10010001010000100000000100001100', '00000000000110001000111011000000', '00100000001010010011000100000001', '00000100100000100000010010110001', '00010000100000010010001001001010', '10000101010100000000100000100100', '00010000100100000000010111000100', '00000000001001111001001000000001', '00000011010011000100100000010000', '01001110000000001110000000100000', '01000100000101000000010100001010', '01000010101010001010000001000000', '10111000000000000001000010010010', '00101001000000010000100000011001', '00000110001000010100010010000001', '10000000100011100001000001100000', '00100000010000001000101100001100', '00000001011100000000001000110010', '00000001001000000000010010011110', '11001110000000010000001100000000', '11110000000000100110000001000000', '00000000010011001001100000000101', '00000000000000110010100110010100', '01010001011010100000000000000010', '10010010000100000101001001000000', '10101001100000000000000000110100', '01100000000011000010100010000001', '00000110000000100010001101000010', '00000000101100011000010000001001', '00011000010001000100010000101000', '00000000000101000001100110100100', '00001101100100001100000000000001', '11001000010000010000000000011010', '00110100101000100010010000000000', '00010100001000101000100101000000', '00000001010101000000011010000001', '00001000000010001011000000100110', '10010010000000011100000000110000', '00001000001110000000000101101000', '00000000000000000101100010011101', '11100010110010000000001000000000', '00100010000000100111011000000000', '00011100000000000110001100010000', '00000011001010000000000011100010', '01000001100001111001000000000000', '00000100010000010000110000000111', '00000000000000101011000010010011', '00110001001010010100000001000000', '00100010110001000000110000000100', '11000000001100000010000110001000', '01001000010001000000000001000111', '00000001000110001001001100100000', '10001100100100000100000000011000', '00110100000001010000100001001000', '00010010110000000000000010001110', '01000000100000100100000101100001', '10001000000001000011011000100000', '10000000001010110000110000010000', '00010011000000000001010110010000', '00101000000000000110100001001010', '00100011000010011000000000000101', '01000100010100010001001000010000', '10000000100100001000001010100100', '01000100011001100000011000000000', '10100110000010001000100100000000', '00000001101000100110000001000010', 
             '00000010100010010000100010110000', '10010000011001000010001000001000', '01001000000100001000010001000101', '00111000000000100001000100001001', '00010000000100111010100000000001', '00101000101011000001000010000000', '10000010000001000000011101000100', '00000000000110110100100001000100', '01010101000000001000000010100010', '00001000101000000101000000010011', '00100100000101000000001000111000', '01000011011000000010101000000000', '00000110110000000000000101010100', '00000001000011010110000000001010', '11100100000000000100010000100010', '01010000010100100000010010100000', '10000100001010000001000011010000', '00100000100100000001100000100011', '10011010000000100100010100000000', '00010001000000001000100001011100', '10000100101000101100000000000100', '00001011000001001000001010100000', '01000001000100010010001100000001', '00001111011000000001000000001000', '01110000000000000100101000000101', '10001000010100001010000000001001', '00000000000000000011000111101010', '00010000001011010001010000000010', '00001010000000000010000011100101', '00100001000010100000011000010010', '11000100000101110100000000000000', '01000000111000001001100100000000', '00100001000001100010000010001100', '00010010000010000000001101110000', '01000000110010011000010000000001', '00000100010001010100000100011000', '00000001001000000011110000010001', '00010100000010100000111000001000', '10100000010000011100000001000010', '11101000100101000000000010000000', '01000011000100000001100001000001', '00000000001101010100001100100000', '00111010100000000010000000000110', '00000000110010100000000000111010', '00000110000001100001100000110000', '10100101101110000000000000000000', '10011000000000010000001010001001', '00001000010000001010010101000010', '00000100000110000010001000010101', '01100001000000000000110001101000', '00001000011000001100000110000100', '00000000100001100101010000000110', '00010011000101101100000000000000', '11000000010000010000000110100100', '00000100001000011000001110010000', '10001000100000000011100001000001', '11000000000001001001001100001000', '00111011000010000000010000000010', '01100000000100000100000011110000', '00010000110010000010110000000010', '00000000011001001010010010010000', '00000101100100100000000001101000', '01000010001000110000000000000111', '00000110000010000001100100001100', '01000000101100110000000100010000', '00000100000010011000000001001110', '10110010010000000010010000000001', 
             '00001001000001000100001001011000', '00000010010100000001110010000010', '00110000000000001110100110000000', '00000001101010000100000000100101', '10001000101000100000101000100000', '10100001010100101001000000000000', '00010100000010010010010001100000', '00100100000000000000000110010111', '01001000000001011000101001000000', '00010010100100100001010000001000', '01010000001000000000000010111001', '10101100010010000000000000000101', '10000001000001010110001100000000', '00000001000000110101000100100010', '01001110001101000000001000000000', '01000010100001000010000000011001', '00101000000000000001011001000110', '00010000000010110100001100000001', '10010000010010001000100010000100', '10000011100000001000100011000000', '01100000000000000011010000011010', '00000010000010111000010110000000', '00000000001001000010000001111100', '10011001001101000000100000000000', '00100101011000001100010000000000', '00000000010000010100001001110100', '01001000000100100000001100100010', '00111100000010000100000010001000', '00001100100010010001000000001001', '00000000001000101001010011000100', '00000011000101000000000100110001', '00010000000001000111101000000010', '11000001110000000000011000001000', '00100000001101001000000101000010', '00000000010000010011100000110010', '00011110100000100000100000000001', '11000000000010101000000000010110', '00000010111100000000001100000001', '00000001010110000011000001000100', '10010000100001000100110000000001', '01110110000000001000010010000000', '01000100000000000000101110001001', '00001000001010110010000010001000', '10100011000000010100000000100100', '00101100010001000001000001010000', '10100000000000100000010001011001', '00000100100101000010101100000000', '01000010000100000110000000100110', '01000000101000011100000010100000', '00010000010001100000000101100010', '10011101000010000001100000000000', '01100000000110001000000000001011', '00000010101000010110000000010100', '00000000110101010010000000000011', '10100000001010101000001001000000', '00001001000000000100110100110000', '00000000011001100001100010001000', '00101010000100000011000101000000', '00000000010010001100000010110001', '01000110000000000001001010001010', '10010001010001010000010000000100', '00000110001100101000010000000010', '00000001000000010110100001100001', '10001000100010000000010100001100', '01011000000110000000101000010000', '00000000000000101010011000001110', '00110000011000000101000010100000', 
             '11010000000001000000000111000001', '00010101100000001001000100001000', '00000011000000000100010001000111', '00100110000000010011000010000100', '00001001010001110000001000010000', '11010100100000000001010001000000', '00100011100000000100000110001000', '10000100010010011010000000010000', '00100000001111000000000000100110', '01101000100000000000101100010000', '00010100001010000000100000100011', '01001010010000110000000011000000', '10000001000100100000101000000101', '11001000100000000110010000010000', '00110000000100000000110001010010', '10000111000000110010000000001000', '00000000100111000100000110000001', '00100010011000001001001000100000', '00010000100000001011010000110000', '01000001001001000000001011000100', '00001000001010001000101000001001', '00000000010101000101000100001100', '01001000000000100101110000001000', '10000100000000111000000001100010', '10110000100000010010000100010000', '00001000000111000000000010100011', '01100000011000100010000100000100', '00000111100000010001001000100000', '00010010010000001000011000010010', '11000001000010000100100011000000', '00000000010010000110101101000000', '10100101000001010000000000010010', '01000100001100100001000010000001', '00011000000000001000010000101101', '00000010000001011100100000001001', '10101000101100000000000000000110', '01000011010000000000010000110100', '00010100000001100010000110001000', '00110000000110000101000000010100', '01001000101000000000001001101000', '00001001110100000010000110000000', '00000100000001100000101001000011', '10001010001000000000000100011001', '00000100000010011101110000000000', '01010010000001011010000000000010', '00000001010000000001011011100000', '00000000100011101010100000001000', '10100100001100000000010100000100', '10011000000110010100000000000010', '01100001010000100000000000110001', '00000000000001101100000101010100', '10100000000100000011100000001100', '00001010100010000000011010000010', '00000001111000010001000010100000', '10100110001001000100000000001000', '01010000000010010001001001000001', '00001001101000000000100101000100', '00000010010000101010000000100011', '01001000010000000001010100010001', '00010100000100000110011010000000', '11110000000010010000000000101000', '00000111001100000000001010000100', '01010001100001000010100000100000', '00000000100000101000100101010010', '00000100010100001100001001001000', '00000010000011000001000010010110', '00100000100001001010001000010100', 
             '00000000001000100000110100101001', '10101010000000010000000001000011', '11010001000100010001000010000000', '00100000010100010000010101100000', '01001101000000100000010000000011', '00000000001011001101001000010000', '10010010001010100000000000001100', '00000000100000110000110010001010', '00101100010010000110000000100000', '00010010001100001000000001010001', '10000100000000000110101010000100', '10001101000000000100000110000010', '01000000110001000011000001000100', '00000000101110000001100000011000', '01110001010000011000001000000000', '00100000111000010010100000001000', '01010010000000100100001010010000', '10000111000000000001000100000011', '00011010000101000000010001100000', '00101100000100000000100011000001', '01000000001010001001010000101000', '00001000100001100000000100010110', '00000000000010010000011100100101', '01110100000000000011001000100000', '00000001000101100010010101000000', '10000010010011001100000000000001', '10001000010000101000100010000010', '00110100100011000000000100000010', '00000000011000000011001010000101', '00001001000100011100000000001100', '10000001101000010100000001010000', '00000001001000110000011001001000', '01000010000010000000100000111100', '00000100110000000110000010010010', '01111000000001000000110100000000', '10001010010000001001000000010100', '00000000000100100011001001100001', '11010010001000000000110000100000', '00100001000100100100000010001001', '00010100000001010001000010100001', '10000000100110001000100100000010', '00101111000001100000000100000000', '00000000110010001100010001000100', '00001001000000010001000010000111', '10000000110000000100100001101000', '01100000001001000010001100010000', '00000100001100010010001000001010', '00110001001001000001000100000100', '00000100010000110010001010100000', '00000010100100100100010001010000', '01001000010010001000000001011000', '00001010000100011000100100100000', '00010000001000100000011000010101', '11000110100011000000000000000010', '00110000000010000110010000001001', '11001000010110000001000000100000', '01000001000000001010100010010010', '00000101000001011000100100000100', '00110000101000000001001001000010', '00001000001100010000000000110101', '10000010000000100100010011001000', '00000011000000000010110100001010', '10010000000001100101001010000000', '00001000000111011000010000010000', '10000001011000100000000011000001', '01100100100010000100000100000100', '00010000100000001001101000001001', 
             '00100101000100000001111000000000', '00101000001001100110000000000001', '01010000000000011000000011010100', '00000010010100010100000000101010', '01001000000010100010100001100000', '10010001000000000001001000111000', '01000110010001001000000110000000', '10000100111000000000010000000110', '01010100001110000000000001000100', '10000000100001000000010110100010', '00100010000000010010001000010011', '00000010110000100110100100000000', '10000010000110000000011000001001', '01101001000000001001000000001001', '00101100100000011010000001000000', '00010001000010100101000010000100', '10100000010100000010001001010000', '00000000001001000000100100100111', '01000001000011000000000110011000', '00000100110000001101000000100010', '01001000100000010101001000000100', '10000000001001110000000100001010', '00010110000000001010110000010000', '00000011001000100000110010000001', '10000100001000000000011010101000', '00100000010110100000100100010000', '01011000000100000101000001000001', '00110010010010001000000001100000', '10000010010101100000001000000010', '01000100100000001000100000010101', '00101001000000010110010000100000', '00010001100000010000000111000010', '00010000100011000000001010101000', '00001001011000000011000000000110', '00101010000000101100100000000100', '11000000000011010010010001000000', '10000000011000010101101000000000', '00001010000000101001000001001010', '00110001100100000000010000100001', '01000100001000000010000100011001', '10100000000000001000101000110010', '00000010010000000111000001011000', '01001000000010100000010010000101', '10000100001101000001000100000001', '00000010000111000010100001000010', '00010001110100001000000010010000', '00001100100001010000010100000100', '01100000000000010100001110001000', '11011000001000001010000000000100', '00100101000010100000010010100000', '00000000110010100001101000000100', '00000000000001010000000101111001', '00000001010000011010000100101000', '00010000101011000000000001010001', '00001100001100000101100010000000', '00100011000100100000010000000110', '01001000000010010001100100000010', '10100001011000000000000000101010', '01000100100101001010010000000000', '00010010001010001100001000000010', '00000000000100110001010000111000', '00001011100000000000001001010001', '01000100000001000110100101000000', '10010100000000110000000010000101', '11000001000010100011000100000000', '00001010001100000000100000001110', '10100010100001001000000000100001', 
             '00010000110000000100001110000010', '00001000010100000010110000100001', '10010100000011000000010000011000', '00100100011000010000000011000100', '00000011000000101100001001010000', '00001100000010000000001111000100', '00010001001000000101000000001011', '01100010100100000001000010010000', '00000000000001110010101000100100', '00011101001000001000000000010010', '00100000100000111101000000001000', '10110010000110000000000110000000', '01010000010001000100010000010010', '10000000100010010111000000100000', '01100000000000001010000101100100', '01000001010000000000111001000001', '00001110010001000000001000001001', '10000001000010010000001010010001', '01000000001100101000110000000100', '10001000000000000101000011100100', '00000000101100000010110100000010', '00100010000000100001000100110100', '11010100010001000100000000001000', '00100000001001010000111000000010', '00011001010010100010000000000001', '00000000100100000000000101001111', '00100110000000001100001010010000', '01000000111100000000100011000000', '10000010000010001010010000101000', '00000000000010000101010101001001', '00110111000100010000000000010000', '01011000000001111000000000100000', '00001001000001000000101010000110', '11000001001000001100001000100000', '00011000100000000001110000010100', '00100100011100100010000000000001', '10000000100010010000000111001000', '00001001000000001101011000000010', '00110000000000110001100001100000', '00000110010101000010000000010001', '10000010000011000010000110000100', '00100100000000011000100010101000', '00001000000010100001001100011000', '10010000000100000010010000000111', '01100000111000000100100000000001', '10010010000100100010000000110000', '00000010011000110001000101000000', '00000101001011000100010001000000', '01010000100100100010001000000010', '00101000000001000000010010001011', '10000100001000000100100100010010', '00000011010010001000001000001100', '01000101100000000000000011100100', '00101010001010110000000000100000', '00000001000001001000001100010011', '11000000110100010001000000001000', '01011100000001000010000010000100', '00110010011000000000100000010100', '00000000100000001101011001100000', '00001000110000001001000011000001', '01000100000001110010100000000010', '00100100110000000001001100000001', '10000000001101000100010000110000', '00011001000110000010000000001100', '01000011000000101000000110001000', '01010010110000010000000000100001', '10000000001100001011000000010010', 
             '00101000000011010100000010000100', '00000000001000000100111011010000', '00100001100110000110100000000000', '00010010000000010001100100000110', '10001001010000101000010000100000', '10000100000101001000000001001001', '10010100110000100001000000010000', '00100110001000000000001001100001', '01000000000011100100011100000000', '00001001000000010010000100001110', '10001000000100100001100001010000', '01000001000001001110010000001000', '01100000001010000000000110100010', '00010010000000010000110011000100', '01000100000000001000011101010000', '00000001001000100100100000101100', '00010010100011000011001000000000', '01000000010010000010001000010011', '00010100110100010100000001000000', '10101000000000010001100110000000', '00000010000011100000000000001111', '00000100011100001000000010001010', '00101001000010001000000011010000', '01010000100101000000100000001100', '10000100001000000010010000100011', '00101000110000100000011000100000', '00000010000101010000011000001100', '11000000000000001001100000100011', '00001001000000110100000101000001', '00000100101010000011000100010000', '00000000100000100100101000011001', '00001000011101011001000000000000', '10000010010000000110000101100000', '00110001010000000001100011000000', '10011000100001001000011000000000', '01000001000000000110000100010101', '11000001000010010000010000100010', '00100111000000000010000111000000', '00000100010000000101010010001100', '00010000101001010000001010000100', '00110100000010101000000000011000', '00000010000100011010000011000010', '01000001000011000001000000100101', '00001010011000000000000100110010', '10110100001100100000100000000000', '00100000100110000100011000000010', '00001010000000100010010001010100', '11010000010000000000100010001001', '00001100000010001100000100000011', '10000011100001000001000000101000', '10000001110011000000000001000010', '00000110001000001011000000000101', '00011000001000010000101010100000', '01100000001101100000000001010000', '00001101010100010000010000001000', '11100010000000000001001000000101', '00000000000100100100110100011000', '00010000100010011000000100100010', '00000100000100000001010100110010', '01100000010000100000001011001000', '00011001000000001110100000000100', '10100010001000000010101010000000', '00000010011001100100000010000100', '01000000100010010000101100000001', '01100000000011001101000001000000', '10010001100000000010000000011010', '00000010010000110000010000011001', 
             '00001100000100100010000010100010', '10010001001000001000010001000001', '01000100000000010001101000100100', '01001100001010000000010000010010', '00100000100001100010000011100000', '00010001010110000100100100000000', '00101000100001001100001100000000', '00000001000100010000101101001000', '10010010000010000001010000000101', '00000010101001101000000000011000', '00101100000100010101000000000001', '00000000010000011111000100000001', '00000010010110000010001010001000', '01011101100000100000000000010000', '10000000100001010010000000100110', '01010000000000001100000011001010', '00000110010010100000000110000001', '00100001000001000001010001110000', '10000000001100000110100001000100', '00100001000010000000001100101001', '01100010010000010000100010000010', '11000000000100000000011000110100', '00001000001010000110010100000100', '01000010000001010001000011001000', '00100000000101100000010000100101', '00000101100000100001100000010010', '10011000001000001001000000100001', '01100001001000011000010000010000', '00001100000111101000001000000000', '00000110000000000010101001001100', '11110000110000000000100000000010', '00001000000000101110001010000001', '00001110100011000000000000100100', '00010001000100010100100010010000', '10000000011010000000001100100010', '01000010100000000010010110000100', '00110000010001001000000000001011', '10001000111000000001010001000000', '00010000001100010001000001010010', '00010101010000000000000001010101', '10100001000000001010010100000010', '00000010000001100100100110001000', '00001100001010110100001000000000', '10100000000010000100110000010100', '01001000100100000001000000101001', '10000010000000010000101001100010', '00010000101100001011000010000000', '00000100000001000110010000110100', '00011000010010000000001001001010', '11100001000000110000000110000000', '00000001101001000001100100000001', '00010000001100100010000100100100', '10000011000110000000010001010000', '00100110100000000100100000000011', '01100000110000001000000000011100', '01000000000100010011110001000000', '00010110000000000101000100100001', '01001000011011000000000010001000', '00000100010001111000001000000010', '00000010001001000010010001001001', '01101000100000010000000000110010', '10011100000000000001001100000100', '00000101001000101010001010000000', '01000001010101000001100000010000', '10100000100010110000000000000101', '10000010000010001100001010001000', '00010000000100001100100011100000', 
             '00001001100000110011010000000000', '01010000010010000000000100001110', '00000010010100001000110001001000', '00001100000001100100000000110001', '00100000000010100110000010010010', '10100001001000000000001101001000', '00010100000001001001100010000010', '11000000011100010000000000000101', '00110000000011000100101000100000', '00001011100000100000010100000010', '10000100110000000010000000101001', '01000001001100001001001000000100', '00010100000011001010000001000001', '01000000001000010100010000101100', '00000000100000110001111100000000', '00001010001000001010000010011000', '01000100100001000000001010010010', '10100010010010010001000000010000', '00001001000100100000000111100000', '10001000000000000100100100000111', '00000101000000010101000101000100', '00110000100000000000010011011000', '01101010010100000010100000000000', '10010011000001000000001000000011', '10110010000000101001000000000010', '00000000101010000010100010000101', '00000000010101100000011000110000', '01001001001110010000000000100000', '01100000000000010100010011000001', '00000100011000001000110100001000', '00000100000010100101000001101000', '00001010010101001000000100000100', '00010000010000110110010010000000', '00010000000100001000101100000110', '10000011100010000010000000110000', '11000100100000000000001001000011', '01000110100010100000010000001000', '10000001000001000100000001001101', '00101000011000010001000000010010', '00000000001101000010101010100000', '00011000100000100100101001000000', '01000000011001000011000000100010', '00100011000000001000000100011100', '00110100000000010001010100010000', '00010000000101000100000010000111', '00101100100000000000000110101000', '11000011000010001000101000000000', '00000001010000110011000001010000', '00000010011111010000100000000000', '10001000000000001100010110000001', '00010100000000000001010001100110', '00101001100100100000001000000001', '01100000001000101100000100000010', '10000000000110010010000000011001', '00000001000001000010111000011000', '00001110111000000000000010100000', '00010010001001000100000001100100', '11000000100010001001000001001000', '00111000010000000010001010000100', '00000100000110100000110100000001', '00000000101100000100001010001100', '00100001010000001010100001000001', '01000010000010011001000000110000', '10000000010100100000000101000110', '00000010100001000111000010000001', '10001000000001010000100000111000', '11001000001000101000000100010000', 
             '10010101000000000100010001000010', '00100100100100011000000000000110', '00010010000000000010101110000001', '01110100001000000001000000001010', '00100001110011000000010000001000', '00000100000110000101001000000110', '10000000001000011001000101100000', '00011000010011000000001010010000', '11000001000000100010010010010000', '00101000000101110010000000001000', '00000011100010110000100001000000', '01000010000000001000011000110001', '01001100001000000100100000000101', '00101000010110001000010010000000', '00000000011001000000101100010100', '01010111000000010100000000000010', '00000011000000100001000010101001', '00100100100010000000100001100100', '00011000000000000100000100111010', '11000000011000001011010000000000', '00000000000000100011011100000011', '10100000010001100000010100000001', '00010001100100010010000001100000', '10001010001100010000001000010000', '00000001100000001101000010001010', '00000001010100000100011100000100', '00000110000010010010100000100001', '01110000001001000000000001000110', '00001100000000100001000011011000', '00000001001110000011010010000000', '00100010010001010100001000000001', '11010000100000001000100000100100', '00000100000011001000100001010010', '01000110000110000100000101000000', '10001000000000011001010000001100', '00010000100000100010000010100011', '11010001101001000000000100000000', '10100000000100011001001010000000', '00001000010000100000100000111001', '00000000101010100000001001000110', '01100110010000000000110000010000', '00000000000110101000000001100101', '01100101000000000100001000011000', '00000011010001000101000100000010', '00011000101000010010010100000000', '10001101000000011000001001000000', '01000000110011100110000000000000', '00110000000000000001110010001100', '00000000001100000000100010011011', '00000000100100010111001000010000', '00010001000011000000110110000000', '11001010001000100000000000100001', '10111100000000000010000000100010', '01010001000111000000001001000000', '00000000111000001000000001110001', '10100010000000100000000100001110', '00001100000000001011110100000000', '10000001001101100000000000010100', '01010000000000000010100001001011', '00100010010000011101000010000000', '00001010100010010100000000101000', '00000001011001000110000000100001', '00000000000010110001001010001010', '01000100000001000000110110000100', '10000100100100000000011101000000', '00001101000001000010010010000001', '10100000100100010100100100000000', 
             '00001010000000000001001000101110', '00010000011000101100000001010000', '00000101101000010000000010000011', '01010000000001000001001100110000', '11011010000010000010000000010000', '00100000010110011010000000000100', '00010100010100001000000110000001', '00001011000000001001100001100000', '00100000001010100000011000001100', '01100000010000100100010000000110', '00100010001100000100010100100000', '00000100010001100000100001001100', '10000010100000010000001000011010', '10000001000001000011100010000001', '10000000011010000100000100001001', '01000000000110100001000001010010', '00011011100000001000000010000100', '00101100100001001000110000000000', '00001000110100000000101001000100', '00010001000010011011000000001000', '11000000000000000000000101110011', '01000010001000000010011010100000', '00000000000110010100010110000010', '01010100000000101000000000001101', '00100000001001000011100001010000', '00000001100001110100001000100000', '00000100001000110001000100001100', '01000010000001000000100011100001', '00000011100100000110001000000010', '10111000010000000000000000011001', '10110000000000010000011000000110', '01010000001010000100010010010000', '00101101010000001001000000100000', '10001000010010100010100100000000', '00000000000000011000110010100011', '10000010100100001010000000001100', '00000100000101100001000101010000', '00011011011000000100000000010000', '00001100001000010000100101010000', '00000101000001000010001000101010', '01100010101011010000000000000000', '10000000100000101001000100010001', '01000111110100000000000000000100', '00000000010111000000000011100100', '00110000000000000110111001000000', '01011000000010001001000010001000', '00000110000000010000010001111000', '00001000001011100010010000000010', '10010001110000100100000000000001', '00110000100010011000001000010000', '10000110010000000001011000100000', '10001000001000001110000001001000', '01100000000101000001000000000111', '00000000000010000011101110010000', '00100010100000001100000101000001', '10100000010001100100000010100000', '00000101001000100000000110000110', '01000100000100101100100000000010', '00000000010010010010011100001000', '11000000000001000000001010011100', '01100000101000000000010001100010', '00000001000000111100010000010100', '01011010000100000000100000000011', '00100100001110000010000001001000', '00011001000101010001001000000000', '00000000110000000001100100100101', '00000010001010000110001001000001', 
             '10011001000000100000110010000000', '00001100100000011001000010010000', '10010011010100000000100000001000', '00000010101010001000001100000100', '01000100010000000010100011010000', '10100000000001000100000100100011', '00000000000001010001010000101011', '00100000100000001001010100001010', '10010000010010000000101000100001', '01101011000000000000000010010100', '00001100000101110000000001000100', '11000000000000011010000011000001', '00010001001100100100000000011000', '01000000001000100001101000100010', '00010101000100000110000100000100', '00000000000000101000001010111010', '01000000100100000101010100000001', '00011110010010010010000000000000', '00101000001011000000010001000100', '00111010000001001000001000001000', '10000001110010010000100000010000', '01100100110001000000000100100000', '00000011001000000101100001000010', '01010011000000100010001000001000', '00000000100110110010000100100000', '00000000001000001100110010000110', '10001100000100000000010000010101', '10010010000001100000100000010010', '00100000010100000001000111000001', '01000100010011010001000010000000', '00000001100000000000011000101101', '10000100000001001001000000001110', '00000001100000001010001101100000', '01101000011000000100000010010000', '00011000001000110010000001000001', '00000010001101000011000100001000', '10010100100000000100000010110000', '00101001010010000000110000000100', '10000000000110000100100001000011', '00001100010010000000100000101010', '01010000000000100010010101010000', '10100000100001000101001000000100', '00000011010000011000000100010010', '01101000000000110011001000000000', '00100100001010000000011010000001', '00000011000100001000110000100100', '10000000000101010100000011001000', '00000000000100000110101000101001', '00000010100011001001010010000000', '11110010011000100000000000000000', '00011100101000000000000100000101', '00100001000000000001001010100110', '00001100010101000110000000000010', '00000001000010001000100101010001', '11010010000000110000010001000000', '00000000011000000001011001011000', '01001000101000111000000000000010', '11100100000100001000000000110000', '00010001100000010110000010001000', '00010000110000000011000101001000', '00101001001000001000100000000011', '01000000000001110100100010010000', '00000010000110100000001100000101', '00010000010100110000000010010010', '01100000000000000010110000100101', '10000110000111000000000010100000', '10000001001000100011000000100100', 
             '01001010000000010101000100010000', '10000010001001001000110001000000', '00000000110001001100001000001010', '00100101100010000000000000001101', '00100000010001000010000110010010', '01000001000010100100100000001001', '00010000101110010000010000000100', '00001100001000000000001001100110', '00000100110000101000101010000000', '10010000000000000111010100100000', '10011110000100000000000101000000', '00001010000000001001011001000001', '00100000001000011010011000100000', '00001010100010100100000010010000', '01000001000101000000000000011011', '11000100010000010001100001000000', '00000100001000001001100000111000', '01010000100001110000000000001001', '00100011000110000000000101000100', '10000001000010000110000010000110', '00110000010000100001000000101100', '00001010000001010010011100000000', '00011100010000000100111000000000', '00100001000101001000000011000001', '00010011001000001010010100000000', '00101000001100100100001001000000', '00000000110000010001000000011110', '11000100100010001010000010000000', '00001000010100100001010000001010', '00100010100001000000001001010010', '10010000001011000100000110000000', '11000000000001100000101000100001', '00100010000000000110100010110000', '01010001010000001001000000000011', '01000100000010010000100101000100', '00001001100010000000000100110001', '00011000000000001100001000110100', '10000100000010100010010001000001', '10000100001100010001000010001000', '01000001110100000000100100000010', '00100000000101000101110000001000', '00010010011000010000001000001100', '01100010000011000000000100010001', '10000001001000011000010010000100', '00010010001000010011100000100000', '00001100100010100000000001001010', '01101001010000000000001001000010', '00000000100100001110010000010001', '00110000000000101000110000010001', '01001001010000000011000010001000', '00000100101101100100000000100000', '11000100010000000010000100010100', '00010000000001101000011110000000', '00000101000110010000101010000000', '00100010000000010001000100101001', '11000000000000010001000011000110', '00001010001010000000110000010001', '00010000000111001010000000101000', '00100100000001000000001101100100', '10000010100100100101000000000010', '01100101000000010000000001100001', '00010000001011101000100000000100', '10000000110000000010010010001100', '01001010000000000110000110000010', '00100101100000100101000001000000', '00001001101101001000000000001000', '10000010010000000100101000010010', 
             '00000000010010000000010100110110', '00000000100100100000100010100110', '01010001001000010000001000010001', '10001000001011010001000001000000', '10000100000000001110011100000000', '01000110001010000001100010000000', '00010001000000100010000001010110', '00000010110001000000010101001000', '10101101000000000010000000010001', '01000000100010000001001111000000', '00001000011001010000110000100000', '10110000000100000100001000001001', '00100010000000111000000000101010', '00000110100000100001001010000100', '01000000001000011010100000001010', '10011001010010000000000101000000', '00000010000110001101000010000001', '10000100000000111000101000001000', '00011000000001000000000101010101', '01000000111000000010000000110100', '00100100000100000100010001010100', '00000000010010010100100010101000', '10101010001000100001010000000000', '01001000000000001010001000100011', '00010001000101100000000010001010', '00000000001000010100001001100011', '01000111000001000100100000000100', '00101000110010001010000100000000', '00011000001100001000011000000010', '10110000000010000000000011100100', '01000011100000010000100000011000', '00110000100001000101000100010000', '00010000011101100000010000000001', '00000100100000000100110101100000', '00001000010000110000011010000100', '01000010010110000011000100000000', '10000001000000001011000000001011', '00011000011000000001100001000001', '00100110100100010000010000000001', '10000101000101001100000000010000', '10100000000000100010000110101000', '10010010100000000000100001000101', '00000000001100000001001110010010', '01000000000010100110001000010100', '00000001010011001000000000101010', '00010000110010110000000011000000', '11000001000100001000000100101000', '01100111000001000000011000000000', '00101100001000000010010000010100', '10010000000000110000001100110000', '00100100100100000011000010000010', '00001010010010000100000001000101', '01000001000001000101110000000010', '00000101101000000000101001001000', '00001000001001011010100000000001', '10100000000000010001010000110001', '01010000000110100100000000001010', '00010001000000101000100100100010', '01100010001100001000000010001000', '10001000010001000000010100010100', '00000000010001000111001011000000', '01010100011100010000000000100000'],
    
    #min Hamming dist=8, r=0.25, min column sum  162 and max  297, avgHammingDist=11.8
    '8/32_D8':['00000000001100000101100100001100', '00000000100001001000010001110010', '00000000010010110010001010000001', '10000001010100000000000100100011', '00001011101000000000110000000100', '11000110000001000100001000010000', '00110100000001000010010000000101', '00001110000010010000000001101000', '00101000011000001001000001010000', '00110001000010010101000000001000', '11100000000000101100000010001000', '10001001000011000001000001000010', '00010000010000000000110010100110', '00000000100000010010101100010001', '01011000000101100000000000001001', '00100101000000100010000101100000', '10000100100000000001000010010110', '00000000010110101010010100000000', '01000010101000000000001000100011', '01000011100000100111000000000000', '11101000000010000000011000000100', '00000000001101010000100110010000', '00010000001000011000001100101000', '01100100000000000001010001001010', '00000011000000110000000001010101', '10010110001101000000000010000000', '00000000110011001100110000000000', '10100000011000000100101000000010', '01000000000100000011000001100101', '00000111000010001000000100011000', '00011100000000000100000110010100', '00001000000001010100011000001010', '01110010000100000001101000000000', '00000000111000011000100010000001', '00011010000001100010100000100000', '00101000001100010100000000100001', '00010001000010001010001000000110', '11000100010100000011000000010000', '00000000100000100100000111100010', '01001010010100010000000010000100', '00010000010000000000110001011001', '00000000001001000001011110001000', '11000101000000010000010010100000', '00000000110010101001000000001001', '00010010100100000110000001010000', '00000000001001000010101101000100', '10011010000000000011000000001100', '01000100000001010100100001000001', '00101101010000001000010010000000', '01000100101010100000000000000101', '00010010000000010000001010011010', '00101000100000000111001000100000', '10100000001001000000010100100010', '00010001001010111000000000010000', '00001010000000101100011000000001', '11000101000110000000000000000110', '10000001100100001001000010100000', '00000000100111001010000000001010', '01001001001000001010000000101000', '10100001100000110000100001000000', '00100000010000000000001101010110', '10000010000010100101000010010000', '01000110010000000000100100110000', '10100100000010000010100010000001', '00011000001000000001100101000001', '00110000100100000000010100000110', '00000000010001110001001000101000', 
            '01010001100000000000011001001000', '00100010000010010000010001000011', '00000000001011100100100000010100', '01100000011100001000001000000001', '10011001000100001100000100000000', '00001110000100000001010000010010', '00000000110001101010000010100000', '00000000010011100010100001001000', '00100000000000011110100000100010', '10000101001100000000001000001001', '11010000000001010000010001000100', '11000010100001000000100110000000', '00010100000010010000000100100011', '00000000101100100100001001000100', '00101100010000100001000000001100', '00001001010100000000101010010000', '10010010100000000100000000100101', '00001011011000000010000010000010', '00000001000010010001010110010000', '11011100001000001000100000000000', '00000001000001001100000001011001', '01000010000110000110000100000010', '00000000000000111001010100001100', '00101001110010000000000000100010', '01000000000100000000110010101001', '10000110111010000000000100000000', '00000000000000110101011011000000', '10101000000001000110010000010000', '01100001000000100000101000011000', '00110010101000001010000000000001', '00000000000100100001001001110010', '00001101100101000001000000000100', '00100010000000000001000110011001', '10010100000000110100000000000110', '00000000010010000010000111100100', '00100000000011001100000010000110', '10000000101000000010000000111001', '00001010001110010000101000000000', '01000100100010000001101010000000', '00110011010000010000010100000000', '00000000000101001000001001000111', '10001101000001100000000100001000', '00000000011001011100000000110000', '10110000010110000000100000100000', '01010110000000001000000111000000', '01000000000001101010110000000010', '01001001010000000101000000001001', '00001000000010000010110101000010', '11100010001000010001000000001000', '00000101000000000101000000110101', '00000000111000101000010000010100', '11011000000100000010001001000000', '00010000001010000110010000010010', '00000100000000101000110100100001', '00000000110000110000000011001100', '00010101100011000000001000000001', '11010001010000001000000000010010', '00100110001000000110100000000100', '00000000000101110010010010001000', '00000001101000000011001001010000', '01101010000000100000000001100100', '00100100100100001100000000000011', '10010000000000000001101010101000', '00000000010101010101010100000000', '10001100000000011010000010000010', '00111001001000000000000010001100', '00000000010011010001100000010001', 
            '01001010100000001000001010010000', '10000011000001000010010101000000', '00110010000010100000000100001010', '00000000001101010000011001100000', '00000000100010000100101100100100', '00011110010000000100010001000000', '01000100000000000010100000101110', '10100000000000110000001110010000', '10000000010100000001110000000101', '01000011001001000100000100100000', '00000101101000100000000000011010', '00000000110100010001001001000001', '10000011000010001000010000000101', '00101100000000010000101000001001', '01110000010000100100000000100010', '00000000001101101010000001010000', '00011000000010000001011010000001', '00110001000001100001000000010100', '11001000000010000100100100001000', '01000000011010001000000100100010', '00000000100110100011000011000000', '00000011100000000001001100000110', '00100110100000000000110010100000', '11000100011000000100000010000001', '01100001100000100000010100000001', '00010110000001001001100000010000', '00000000000100010010001011010100', '10001000010110010100000000000010', '00000000000001011010000001101100', '01100110000000110010000000010000', '00000000101000001001110000001010', '10010001010000000110000010100000', '00001101001010000001100000100000', '00000000001111000000000011001100', '00011000000001010010000000010011', '10001010100100000000000100001001', '00011100000000001000001001011000', '01000010010000000010001100000101', '10010000101001101000000000000010', '01100001000001001100011000000000', '00000000010110010000110011000000', '10100011010000001000100000001000', '01110100000001000000001100100000', '00000000101010010011000000000011', '00000000000100101101000101000001', '10000010100100000010101000000010', '01110000001010000000000001101000', '00001100000001010000010111000000', '00000000100000100100000100011101', '00010101010100001000000000100100', '00100011000100000101000001000010', '11001000001010000010000010010000', '00000011000000100000010001101010', '11001100110000100000001000000000', '00110000000000110000000010100101', '00000000000000001111111100000000', '00100001000001000100100100010010', '01001000000000100001100000010101', '10000110000000000010001010100100', '00000000101101000100010000011000', '00000110010110011000000000000001', '01001001100000001100000001000100', '10011000000000010000010100011000', '00000000011100010001100000100010', '00100101000011000000000010101000', '00110010011000000000001011000000', '10001000001000000000010001010110', 
            '00000000000011111111000000000000', '00000000110011000011001100000000', '00010100100000000110000100001010', '01000001001010000000100001010001', '00111010000100111000000000000000', '01100000000000000000011010010011', '00000101100100010100000100100000', '10011010010001000000001000000001', '00000000011000001001000010101100', '10001100000000100010110000000100', '01100001011000000011010000000000', '11000000000000110000000001101001', '00000010100101100000000010000110', '00000000000011000101100111000000', '10000100001000001000000100010101', '00010010110010000001010000000010', '01001000000001010000101000110000', '10010001001100000000110000010000', '01000011000011000010000000001001', '00011000000000000100100001001110', '00000000110010100000011001100000', '00100110000100001010000010001000', '10101100100010010000000000010000', '00100001010101010000000000000101', '00000000001100000110010111000000', '00000000000000111001101000000011', '10010100000000000001000101100100', '01100000100100000011000100001000', '01011001000000100100010000010000', '00000000001010001000001010001011', '01011100010000010001000000000010', '00100011000010000000101001000100', '00000000110000000110010100110000', '00000000000111101000100010000001', '10001000001100101000001000100000', '10100010100001010000001000100000', '01000010000000000101100010001010', '00000000000001101100010110010000', '00000010010100000100000000111001', '00011001100000110010000000000100', '10100101001000000001000011000000', '10100000000000001010000001010011', '00000101000100100001000110000010', '01000110000010001100000000100100', '00000000011001010000110000001100', '10010100000010001000011100000000', '00001010000000000000010110100011', '01010000010110100000000001000100', '00000000101001010101101000000000', '00001110001100000010000001000001', '11001001000000011001001000000000', '00100001001000000010001100001010', '00000000110011000000000000111100', '00111100100000100000100100000000', '11100001000100000000000001110000', '00010000010000000011000010010101', '00000000111000010100010001000010', '10000001000001010000100010001001', '01101000010000000000000110101000', '01010100000011000011000001000000', '00000000100000100100111000010010', '01000110001001001000000000001010', '00001001000110000100001000000101', '10100010000011000000000100010100', '00000000011000001010110001100000', '00010001000001100000100001000011', '10100110000110100000010000000000', 
            '01001010001000000000000100011100', '00000000010100000011011010100000', '00100010100000000100100001001001', '01001001000001000000010010000110', '10010100100000010010100000100000', '00000000110000111100001100000000', '01010001000000001001100100001000', '00001010101010100000000010100000', '10000000000001100110000001000101', '00000000010000010111001000010010', '00100100001000010001010100000001', '00001000100100000000001011001010', '00110010000000001000010010010100', '10000101010000101101000000000000', '01011100000110000000000010100000', '00010011000100000001010000001001', '01010000101000000010000001000110', '00000000000011001010100100110000', '00010110001000010000001000000101', '01000000010101010000000000011010', '10001001100000000000011000110000', '00000000000000111010100111000000', '00100000000010010110000000010101', '01000111000100000000011100000000', '00000000111000100100100000101000', '00000000001100001001101011000000', '10100000000000100001100100000110', '00001000100011011000000000100001', '01001010000101001101000000000000', '10100101010001000010001000000000', '10010100000010000100000001001001', '11110000110000010000000010000000', '00100010000000001000001000101110', '00000001011101000100100001000000', '00000000001110100000011010010000', '00001011000000110100000010001000', '11101000001001000000000001000001', '00000000100010001011010000100100', '10010000000000000000100110010011', '01001000010000001000101000000110', '00100110010001000000000001011000', '00010001000000000101010100100010', '10000010000010100010000000100011', '01100001000100101010000000000100', '00010100001000000010100011010000', '00000000000111100001000100011000', '00000000100000011101010000010001', '01000100000000110000001100001010', '00111000010100000110000000000100', '00010011100000000001100011000000', '00000000011010100000110000000011', '11000010001000001110010000000000', '00011101011001000000000000010000', '00000000000010010000011010101100', '01010000101100000100000100000001', '10100100000101010000000001000010', '00000011000001011010000010010000', '00000000100000100001101101001000', '00011001000010000000010001100100', '01000100000000100110001000100001', '00000100100001001000001110000010', '00000000111000010001000100011000', '10001000000000001001010001001001', '01100011010010000000000010010000', '00010010000001100101001000000010', '00000000000100010010110100100100', '10101000010100100000000000010001', 
            '10000010001010000000100000001110', '11100100100000000100000101000000', '00111000000000001001100000100100', '01000100000010010000011001010000', '00100001000000000110010010001001', '00001100001000010000100100000110', '01000001000001010001000000100011', '00000000110110001000001010000100', '10001100000100000101000000101000', '00111001000011000010000100000000', '00000000100100001010110010010000', '01100000001000000001000000110110', '00010101000001011000010000001000', '00000010000110000100001011100000', '00000000111000100010000101000001', '00100101110000000000100000010001', '11001010000000110000010000000010', '10000010101000001000000011000100', '00000000011101000010000100101000', '00010000000010100000001000111001', '01000111000000100000100010000100', '10011000110000000000000101000010', '00000000000011000101011000110000', '00101100001000001100000100001000', '10000011000000000101101000000001', '11010000000100000001010010000010', '00000000101010101010101000000000', '00000000110001011001000000000110', '01010100010000000100101000001000', '00000011001100000000000010100101', '00000110000000001001000001100011', '11010001001000100000000101000000', '10110010000000000100011000001000', '00000000100011010010100010000100', '00001010100011000100000000010010', '00001000000001000011000010101001', '10001100000100000000100101010000', '00000000011100011000000101000100', '00110101000000100000011000000010', '00110000000000000011010101010000', '00000000010010110100010000011000', '01100010000000011000100000000101', '00000000111111110000000000000000', '00001001000000000110000001100011', '00101110001000000000001000110000', '01111000010001000000110000000000', '00000000100101010000001100001100', '01000001100100000010000000010011', '11000011010001000001000000000100', '00000000000010101001001110100000', '10110100001000100010000000001000', '00001000000010000001000110001110', '01110010000001000100000010000001', '00000001000000010110110001010000', '00000000001110011010000010100000', '00001100110000000000000010100101', '00001100000010101000100000001010', '10000001000000001000100001100110', '11000100000000000010010100001001', '00000000010101100000001111000000', '01100010101000000000010001010000', '00000000001111000011110000000000', '00000001011000000000011001000101', '01010100100000101000000000101000', '11000001000000010100000100000101', '00001110100000011100100000000000', '10000010000000000100000101011010', 
            '00100011010100100000001000100000', '00010000000010011001000001000101', '00101000000010011000001100000010', '00010100001001000100100000100010', '01101001000100010000010000001000', '00000000011000000101110010010000', '00010100010100000000001000010011', '00010011000000000010100100010100', '10000100000001100000010010000011', '01000000000001100001010101100000', '10011010000000000000000011110000', '00000000100010000111100000011000', '00000011100100001100001000001000', '00000000001001111000001010000100', '00101011000000001000000101000001', '10000100100001000100100000001100', '00000000010011010010010000100010', '10001000101000000001001000000101', '11000000100010000000010100010010', '00001111000000100001001001000000', '00000000010010001110001000101000', '00100100000100000011001000000110', '10000010001000010000100100100001', '11000000000000010001100011010000', '00000000111010000010010010001000', '00000000101000110110000010010000', '00110101000100000000100001001000', '00011000011000001100000000000011', '11000001000010000011000100100000', '11010010000000101000001000000100', '00101000000100000001110110000000', '01000000000100001100000010010101', '00011001000110000000000000011010', '00110010000010000011000010100000', '00000100010001100000101000000101', '01100101001000010100000000000010', '01001010000000000001011000101000', '00000000010011100100000100100001', '01100001100000001000100010000010', '00010110100010000000000010001100', '00000000010101100011000000000011', '10110100000000001100000000110000', '01000010000000001010100001011000', '10000001101001010000000000010100', '00000000011100100100000100010010', '00000010000001000000110001100101', '01001101101000000000000110000000', '00000000110000001001010111000000', '00000000011100100001010001001000', '00101000000000110000000001011010', '10110001000000001000001010000001', '00011000000001010101000001100000', '10010000011000000010010100000100', '10000000100111000101000000000001', '00000110000001010000000000110110', '00100111100001101000000000000000', '00000000000110000010101110001000', '11110000000000000000000000001111', '01010000000011010100000100010000', '10001110010000000001100010000000', '00000000000100100010111001000001', '00000100010100000100000011000110', '10101000000000000010100001101000', '00000000001100001001010100110000', '00000000001010110100001000100010', '00000001000001000000001110010101', '00000000111001001000001001001000', 
            '00000000110000110011110000000000', '01101000000010001000000000011001', '00000110000000001010010100000110', '00010011000001000000011010100000', '00000000100110010110011000000000', '00101000000001100000001000100011', '01000100001100000000110001000100', '01101100000001000001000010010000', '00000010010100000011100101000000', '00000100100101000000000001101001', '00000001010000000001100000011110', '10001011000010000000001110000000', '00010000100010110100100000000001', '00010001000000010000000111000110', '00101011100000000010000000011000', '10001000100000100000000000101110', '00010000100000101000000011010001', '10001110000001001000010000100000', '00000000100110011001100100000000', '00000000011001100110011000000000', '01100000000001010000001011001000', '01001011000100000000100000100010', '00110000000000000101001100000101', '10000000011011001010000000000001', '10000111100000000100010000000010', '00100010101000110000000100000100', '00100100000000000101101001010000', '00000000000000111010011000110000', '00000000000110001101010010001000', '01010000000000001010000010100011', '10000000010001000000101100011000', '00000000001010110010010001000100', '11010010000100010000000000010001', '00100001011000000000100100100100', '00010111001010000000000001000010', '01001000010100000000010001000011', '01001101000000000010001000010100', '10110001100000000000000100101000', '00000000010110100101101000000000', '00000000111100001111000000000000', '01001000001000111000000100000001', '01000100000000101000000001010110', '00000000100001000010111000101000', '00011100001000000000010000101001', '10001000000000000110001100000110', '00101010011010000000000000000101', '00010010100000001000100100100010', '01001100100000000000110000011000', '00000000001000101101001000011000', '00000000011001010011000011000000', '10001101010000010000000001000001', '01110100000010000000100000010100', '10000001000000001000010110001010', '00000000001101100101000010100000', '00100001100010000001000010000101', '00100100000100000000000100111010', '00000000110000000110101011000000', '00000000000011001010011011000000', '10011001001000010000000000100010', '00001000000001001100100100000101', '00000000010010000001001011011000', '10000010011000000001000000010011', '10011000100100000000100010000100', '00000000000010011100010101100000', '00000000011100010100001010001000', '01000100000000001001011000000101', '00100010100000010001100000010010', 
            '00000000001001110100000101001000', '00000000110010010101000010100000', '00000101000000000000101010100011', '10100101000000000000010000011100', '00000000101010100101010100000000', '01011010100010000000000001000001', '01000000000000110011000010000110', '00110000001100000000000001010101', '00111000000000001010010000001010', '00100000100000001000011100011000', '00000000001110100000100101100000', '11000000000011000000000010100101', '11000001000000000100001000101010', '00000000100111000000101001010000', '00010111000000100100000100000001', '00000011001000001100000000010110', '00000000000100101011100000101000', '00000000000011110000111100000000', '00000000100101011100000011000000', '00000100000000010011000001011001', '01100110110000000000000000000110', '10010000000100000010000000110110', '11000000100000001000101000001001', '00000000010100001100100110100000', '00110000000001010000101000000110', '00001001101001100100000000000001', '00000000100000100001010010111000', '00000000001100110011001100000000', '00000000011010101100000011000000', '01000010000001100000000100010011', '01010011000000010000000000101100', '10100000000000000000010111000101', '10101010000001000000000010001010', '00010000110000000000001110001001', '01000010000000000100011001000110', '00000000001100000110101000110000', '00000000110001010000100101100000', '10111000000000000001001000010010', '00000110000010000001100100000101', '00000000001001000001100001111000', '00000010100100000000011000010101', '00001000010000101001010000100010', '00000000100000010100110110001000', '10000001000010010000001000010011', '01110001000000010010000001000001', '00000001000010100000000100110110', '11001100000000000000000011001100', '00000000110100011000010000101000', '00000000101010010000001111000000', '00000000101001100000110011000000', '00000000001100111100110000000000', '00001000000000010000001101100101', '10000000000100001101100000010010', '00100010010100000000100010000011', '10010001000000000100001001010100', '00000000010000100111000110001000', '00000000001000010111010000101000', '00010001101000000000010010000011', '01101100000100000000000100000101', '00101000000000000010100010010110', '01010110000000000000110000000011', '00000000000000001100110000111100', '00000000000110000010010001111000', '00000000100100001010001101100000', '00000000001010001011000101001000', '00000000100101101001011000000000', '00000000011010011001011000000000', 
            '00100000010000001100000001100101', '00000000000011000000110010011010', '00000000001111001100001100000000', '10000110000000100000100000011001', '01000100000001000101000100000110', '00011000100100000001000000100011', '00000000010000100100001010110100', '00000000001001001110100010001000', '00000000101001011010010100000000', '10000000100100011010000000000101', '00000100100000010001011000100010', '00000000100001000010000111011000', '00000000010101011010101000000000', '00001001000000000011010100000101', '10010110010000000000000000101010', '11100010010000000000010000100001', '00100001100001000000000001001110', '01010001001001001000000000000101', '00000000001000101000100010110010', '00000000110010100000100110010000', '00000000000100011110000100011000', '00000110000000000110000010010011', '00000000000010100101000001101100', '00000000100101100110100100000000', '01000001000010101100000000000011', '00111100000000000000000011000011', '00000000001100110000000000111100', '00000000100000011000000110110100', '00000000001010000100111001001000', '00000000011001101001100100000000', '00100001000000000001001001101001', '00011010010000100000000000010110', '11000000110000000000000001010101', '00000000010000011000001011100010', '00000000000101001000110101001000', '00000000111100000000111100000000', '01001000000010010000100010000011', '10110010000000100001000001000001', '10000000000010100000001011000110', '00000000001001000010010010110100', '00000000001010000100000110111000', '00000000000110111000001001001000', '00000000011010010110100100000000', '00000010000001010011011000000001', '10100011000000010010000000000110', '00000000110001100101000001010000', '00000000010001000100010011101000', '00100100011000000010000000100011', '01011001000000000000001100000011', '00000000100000100010100001110100', '00000000100100001001000001011100', '00000000010000101000111010001000', '00001100000011000000000001010101', '01010000000000000000010100110101', '00000000000001010011100100001010', '00000000000110001000111000100010', '00000000000101000111001001001000', '10000100101000000000100001000011', '00000000010010001101000100010100', '00000000101000000011100110100000', '00000000001010110001100010001000', '00000101000000001010000011000101', '00000000000100010100010010110010', '00000000100011100100001010001000', '10000010000001011100000000000011', '00000000000100101000101100010100', '00000000011000000101001101100000', 
            '00000000010011011000000110001000', '01000000100000000110110000000101', '00000000010010000100100001110010', '00000000100000011011001010001000', '00100100000010100001000000010011', '00011010000000001000100010001001', '00101100000000000100010000100110', '01010101000000000000000010011001', '00000010000010000011000001010110', '00000000100110100000110000001100', '00000000100111000000010110100000', '00000000101011000110000001100000', '00001001000000000000100100111001', '00000000101011000000011000000110', '10000000010100000010000011001001', '01000000000100000000001110100110', '00110011000000000000000000110011', '00000000011101000001001000010100', '00000000010000010010011101001000', '10000000000001101001000000110001', '00000000001000100100010010001110', '10011000000010100000000100000101', '01100000000000000000100101100011', '00010000000001001000000100011110', '00000000100100110000010101010000', '00000000000001101100101001100000', '00000000010000011101100001001000', '00001010000000000101000011000101', '00000000010000100010010011010010', '00000000101000001100011010100000', '00000000110101000001100010001000', '00000010011000001000010100001001', '00000000100110010000000001100110', '00000000011000001010001110010000', '00100000000010000010011100100001', '00000100000010000100001000011110', '11000011000000000000000011000011', '00000000001000100001111000100100', '00000000110010011010000001010000', '00000000101100101000000110001000', '00000001011010010000000000101001', '00000000001110101001000000000110', '00000000000001011001001101010000', '00001000110110000010100000000001', '00000000001101010110000000000110', '00000000000000110101100100110000', '00000000100000101110010001001000', '10001000000000000100001010011001', '00000000000010010101110000000110', '00000000000001010110001110100000', '00101000101000000000000100010011', '01010000000000000101000001010011', '00000000001000010100100011100100', '00000000010001000111100000100100', '00000000100011010001010001001000', '00010010000000000010000101101001', '00000000010001000010001010001110', '00000000000001100011101010010000', '00100000001001110010100000000001', '00000000000110001000000111010010', '00000000110100100001000100100100', '00000110000000000000011011001001', '00000000010100110000011000000110', '00000000010101100000110000110000', '10101001000000000000110000000011', '01000000101000000001000011001001', '00000000010001000001000110110010', 
            '00000000000111011000010000010100', '00000000110000001010100100001100', '00000000000100100100011100101000', '00000001100000101000001000100101', '00000000001010000001101100010010', '00000000110110000100000101001000', '00001010000000001010000000110101', '00000000100001000111010010000010', '00000000101100010010100001001000', '10010101000000000011000000000011', '01000000001000001101100000100001', '00000000011001100000000001100110', '00000000000010101010000010011100', '00000000000010100110001101010000', '00001001000000001001000010010011', '00000000000011001001101000001100', '00000000100010001000100011101000', '00010000001010000010100000100101', '00000000010000011000110100010010', '00100000000001010000010000111001', '11001100000000000000000000110011', '00000000001000010001001001001110', '00000000001001001101010001000100', '00000010000010010100001100001001', '00000000101100100010010000100010', '00000000110100010100100000010100', '10100000000000000101000010100011', '00000000101000000000101010011100', '00000010101100100001100000000001', '00000000001000010010000101110010', '00000000100000100010011110000100', '00000001000010100000000111001001', '00000000010111000000100100000110', '00000000111100000000000011110000', '00000100000000010000110010010101', '01010000000000000000101011000101', '00000000100010001101001001000010', '00000000001001000100001011010010', '00000000000111010100100000101000', '00000000101110000001001000101000', '10010000000000000000011001100011', '00000000000100100111010000010100', '00000100000000011100000010101001', '01101010000000000011000000000011', '00000000010010001000010001001110', '00000000010000010001010001110100', '00000000001000100010110100011000', '00001111000000000000000000001111', '00000000110000001001101000110000', '00000001100100000000100101000101', '00000000010001001110000101000010', '00000000000011110000000011110000', '10100000000000000000101000110101', '00000000001011100010000110000010', '00000101000000000000010101010011', '00000000000000110110101000001100', '00000000000100010001000111101000', '00001010000000000000101001010011', '00000000001010001000110110000100', '00000000100010110010000100101000', '01000000000100000000001101011001', '00000000000101000001010000101110', '10100110000000000000001100000011', '00000000100001001110001000010100', '00000000100100110000101010100000', '00000000001100110000000011000011', '00000000010011100001010010000100', 
            '00000000011110001000100000011000', '00000000000010010011101001100000', '00000000100010000100010000101011', '00000000001100001010011000001100', '00000000011011000000010101010000', '00000000100000010100001010000111', '00000000101001100000001100110000', '00000000001001000001100010000111', '00000000010100001100011001010000', '00000000101000111001000001100000', '00000000010000101000000110000111', '00000000010001001011010000011000', '00000000000010100110110010100000', '00000000001111000000000000110011', '00000000000101001011000110000100', '00000000100000100010100010001011', '00000000010000100100110101000100', '00000000110100100010001000011000', '00000000100001001101000100101000', '00000000110000001010011000000011', '00000000001010000111001010000100', '00000000000010101001110001010000', '00000000010100110110000001100000', '00000000000101000100000110001011', '00000000101110000010000100010100', '00000000011011000000101010100000', '00000000100000011000000101001011', '00000000011000000110000001011100', '00000000100100000101110001100000', '00000000000100101000010000011011', '00000000000001100000100110101100', '00000000110011000000000011000011', '00000000001000010100011100010100', '00000000011000110000010110100000', '00000000001100001010100100000011', '00000000010110010011000000001100', '00000000000010011100101010010000', '00000000010111001001000001100000', '00000000010001000100010000010111', '00000000001000100010001011101000', '00000000110000000101100100000011', '00000000100001110100010000100100', '00000000010100111001000010010000', '00000000001001001000111000010001', '00000000000100011000100010001110', '00000000010010000001110100101000', '00000000100001000010000100100111', '00000000001011010010001000011000', '00000000001100000101011000000011', '00000000100010000100010011010100', '00000000000001011001110010100000', '00000000000100100100100000100111', '00000000100100000101001110010000', '00000000010000100100001001001011', '00000000101010011100000000001100', '00000000010000010010100010111000', '00000000000110001011001000010001', '00000000100001110010001001000010', '00000000101000000000010101101100', '00000000000110000001100001001011', '00000000000111100010001000100100', '00000000110001010000011010010000', '00000000000000110110010100000011', '00000000010101101100000000001100', '00000000001110010101000001010000', '00000000001011101000010000101000', '00000000110000110000000000110011', 
            '00000000010000010001101110000100', '00000000100010001110000110000001', '00000000100000101011000100010010', '00000000110000000101011000001100', '00000000000101000001010011010001', '00000000001000010010111010000010', '00000000100011101000000101000100', '00000000001001000100001000101101', '00000000000101000010100011100010', '00000000010110010000001100110000', '00000000001000100001000100101011', '00000000001000011011100000010100', '00000000100101010000110000000011', '00000000010000101011001001000100', '00000000000100100100100011011000', '00000000001010000100000101000111', '00000000011000110000101001010000', '00000000010010001000010010110001', '00000000001000011101000110000010', '00000000111001000100000110000100', '00000000100001000001001000011011', '00000000100000011000111001000100', '00000000000110000010010010000111', '00000000100110101100000000110000', '00000000001001000111000100010001', '00000000110000000011000001101010', '00000000000101110001100001000100', '00000000010010001000101101000001', '00000000001110010000010100001010', '00000000010100000000010110011100', '00000000001000101011010010000001', '00000000111001000010100000010010', '00000000111000010010001000100100', '00000000100010000001000101110001', '00000000000010100011011000001010', '00000000000101000100111010000100', '00000000010001001000100000101011', '00000000000001100000011001011100', '00000000001000100100101110000001', '00000000101100011000001000010010', '00000000010010111000100000100100', '00000000001000010010000110001101', '00000000001100001100000001101010', '00000000010111000110000010010000', '00000000100000100001010001000111', '00000000101011001001000010010000', '00000000000101000001101100100001', '00000000010010000100011110000010', '00000000000010010000100101011100', '00000000001000100100010001110001', '00000000010100000110110000001010', '00000000001000101110000100100100', '00000000100000010010010011100001', '00000000000110110010100000010010', '00000000101100010001010010000100', '00000000010010000001001000100111', '00000000000101001000001010111000', '00000000100001110001000110000001', '00000000110000001100000010011010', '00000000000011000110010100001100', '00000000001000011110001001000001', '00000000010001000001111001000010', '00000000010001110010000100010100', '00000000111100000000000000001111', '00000000101010010000110000110000', '00000000000100010111100010000001', '00000000001000101000011101000010', 
            '00000000010001001000100011010100', '00000000000110110001010000100001', '00000000001001001011001000100010', '00000000100001000001110100010100', '00000000000100100001001010001101', '00000000011000000000100111001010', '00000000011010100011000000110000', '00000000100001000100011101000001', '00000000110010100110000000000110', '00000000100001111000100000011000', '00000000000110001000000100101101', '00000000000100011011010001000010', '00000000100000010100001001111000', '00000000010000101110100000010001', '00000000011011000101000000001010', '00000000101101001000100000100100', '00000000000110000100110100010001', '00000000010100001001001100001010', '00000000010000011110010010000100', '00000000001001000010010001001011', '00000000001011010001000100100100', '00000000001000011000010011011000', '00000000010000100001100011100001', '00000000100010000010001010110010', '00000000000100011101001000100100', '00000000000011110000000000001111', '00000000101000001100100101010000', '00000000000100100010000110110001', '00000000010010110001000101000010', '00000000010001001000011100100100', '00000000000011000110101000000011', '00000000010010000010111000010100', '00000000101110001000010001000001', '00000000101110000100100010000010', '00000000000000000011110011001100', '00000000100101010011000000110000', '00000000011001100000000010011001', '00000000010000010100000100101110', '00000000110100100100010010000001', '00000000001000100111100001000010', '00000000100001000001001011100100', '00000000010000101000000101111000', '00000000001010000001010000011101', '00000000110010010000101000001010', '00000000000001101010001100001001', '00000000000101000010011100010010', '00000000100000101101100010000100', '00000000010000010100111000100001', '00000000101101000001000101000010', '00000000000110001110100001000100', '00000000000000001111000011110000', '00000000011110000001000110000001', '00000000100010111000010010000010', '00000000100010110001001000010100', '00000000001000010100100000011011', '00000000110101000010010001000100', '00000000001000011000010000100111', '00000000000000000000111111110000', '00000000010100110000100100001001', '00000000001101100000101000001010', '00000000100100000110000010101100', '00000000000100010001111000011000'],


    #min Hamming dist=4, r=0.125, min column sum  125 and max  125, avgHammingDist=7.007
    '4/32':['00010000010000000000001000001000', '01100000000000001001000000000000', '00001000100000000100000000000100', '00000000001010000000000001000001', '10000000000000100000100000100000', '00000101000000000000010100000000', '00000000000101000000000010000010', '00000010000000010010000000010000', '00000100000001000001000000010000', '00000000100000010000000001000010', '01000010000000000000000000100100', '00000000010110100000000000000000', '00011000000000001000000100000000', '10000000001000000010000010000000', '00100001000000000100100000000000', '00000000000000000000011000001001', '00000000000000000001001010000100', '01000000000000100100000000000010', '00001001000000000000000001100000', '00000000100010001000100000000000', '10100000000001010000000000000000', '00000100000100000010000000001000', '00000010001000000000000100010000', '00010000010000000000010000000001', '11001100000000000000000000000000', '00000000010001000000000001000100', '00000000000000000011000000000011', '00000000000100010100010000000000', '00110000000000000000000000110000', '00000010000000101000000010000000', '00000000101000000000101000000000', '00000001000010000000000100001000', '00100000001000000000010000000100', '00001010000000000000000000001010', '00000100000010000100000010000000', '00000000000000110000001100000000', '10010000100100000000000000000000', '00000000000000001010000001010000', '01000000000001000001000000000001', '00000001010000000000100000100000', '10000000010000000000000100000010', '00000100000000011000000000100000', '00000000000000000000110011000000', '00010000000010000010000000000100', '00101000100000100000000000000000', '00000011001100000000000000000000', '00000000000000000100001000011000', '00000000100001000010000100000000', '10000010000000000001010000000000', '01000100000000000000000000010001', '00001000000000010000100000000001', '01000001000000001000001000000000', '00010000001000000001000000100000', '00000000000100100000000001001000', '00100000000001000100000000000010', '00000000010010000000000010000100', '00001000000010000000001000000010', '01000000000100000000000100000100', '10000001000000000000000010000001', '00000000011000000110000000000000', '00000000100001001000010000000000', '00000000000000000001100000011000', '00000110000000000000000001100000', '00110000000000110000000000000000', '00100010000000000010001000000000', '00000000000000000100000101000001', '10000000000000100000010000010000', 
            '00001000000000010001000010000000', '00000100010000001000000000001000', '01000000000100000000100000000010', '00000000001001000000000000100100', '00010001100010000000000000000000', '00010010000000000100100000000000', '00000000000000000000010110100000', '00100000000100000000001000000001', '00001001000001100000000000000000', '01000000000000010010000000001000', '00000100100000000001000000000010', '10000000010000001000000001000000', '00000000001010000000000000010100', '00000000100100000000000010010000', '00000100000000100000001000000100', '00000010000001000000100000000001', '01100000011000000000000000000000', '00001000000010000010000000100000', '00000001000000010100000001000000', '10010000000000001001000000000000', '00000000000000000000010100001010', '00100001000000000000000000010010', '00000000010100000101000000000000', '00010000000001000000001010000000', '00000000000000001010000000000101', '00000000100000100000000000101000', '10000100001000010000000000000000', '01000000000010000000100001000000', '00001010000000000000010100000000', '00000011110000000000000000000000', '00001000001000001000000000000010', '00010100000000000010100000000000', '10000000000010000000001000100000', '00000000000000000001000101000100', '01000000000000010000010000010000', '00000000000001100000000000001001', '00100000000100000100000010000000', '00001000010000000000001000010000', '00000000000011001100000000000000', '11000000000000000000000000001100', '00000000001000100001000100000000', '00000000000100010000000000100010', '00100100000000000000000010000001', '00010000100000000010000001000000', '00000011000000000000110000000000', '00000000010000100010010000000000', '01010000000000000000000010100000', '00000010000100001000000000000100', '00000100001000000000001001000000', '00000000000010010000100100000000', '00000001100000000001000000001000', '10001000000000000000000000010001', '00000000000000001000100010001000', '00000010100000000100000000000001', '10010000000000000000000000000110', '00100000000001000000001001000000', '00000000000010100101000000000000', '00001000000100000000010000100000', '00100001000000000010000100000000', '01000100010001000000000000000000', '00000000001000010000000000010010', '00000000000000001100000000110000', '00010010000000000000000001001000', '00001000000001000000100000000100', '00100100000110000000000000000000', '01000000100000000000001000000001', '00000000010000010001010000000000', 
            '00000001000000100000000100000010', '00010100000000000100000100000000', '00000000000000000010001000100010', '00100000001000000000100000001000', '11000000000000000000000011000000', '00001000000000100010000010000000', '10000010000101000000000000000000', '00000001000000010000010000000100', '00000000100010000000000000010001', '00000000011000001001000000000000', '10000001000000000100001000000000', '00000110000000000000000000000110', '00000000000000000000100110010000', '00011000001001000000000000000000', '00000000000010010000000000001001', '00100000100000001000000000100000', '01000000000100000001000001000000', '00010000000100000000000100000001', '00000000000000000011110000000000', '01000010010000100000000000000000', '00101000010000010000000000000000', '10000000000010000000010001000000', '00000000100000100000000000010100', '00000001000001000010000010000000', '00000100001000000100000000000010', '00000000000000001000001000101000', '00010000010000000000100000000010', '00000101000000000000000000000101', '10000000000001000000000100100000', '00100010000000000000000010001000', '00000000000100101000010000000000', '01001000000000000001001000000000', '00000000000010010110000000000000', '00000000101000000000000001010000', '00000100100000000000010010000000', '00010001001000100000000000000000', '00100000000010001000000000000010', '00000000000001010000101000000000', '00001000010000000100000000001000', '00000000000000000010000100100001', '10000010000000000000000000010100', '00000000110000000000001100000000', '00010000000001000000010000010000', '00000100000000100000100000000001', '00000010000010000001000001000000', '11000000001100000000000000000000', '00000001000000011000000010000000', '00001000000100000010000000000100', '01100000000000000000000001100000', '00000000000000000101000000001010', '01000010100000010000000000000000', '00000000000000000000000011000011', '00000000000000000001100000100100', '00000000000000000110011000000000', '00000101010100000000000000000000', '10100000000010100000000000000000', '00000000001001001000000100000000', '00011000000000000000000000011000', '10000000100000000000100000001000', '00100010000000000001000100000000', '00000000001000010000000000100001', '01000000000010000000010010000000', '00000000010100000000000001010000', '00010100000000001000001000000000', '00000000000001100110000000000000', '00001001000000000000000000000110', '00010000000000010100000000000100', 
            '01000000001000000000000100001000', '00000000000011000000000000110000', '00000010010000001000000000000001', '00001100000000000000110000000000', '00000000000100100001001000000000', '10000001000000000000000001000010', '00100000100000000010000010000000', '01000001000000000010100000000000', '00000000000000000101000010100000', '00000000000011000000000000001100', '00101000000000000000000001000001', '00000000000000001000010000010010', '00000000001100000000001100000000', '00000000110000110000000000000000', '10010110000000000000000000000000', '00000100000000100010000001000000', '00000000010001000000000000100010', '11000000000000001100000000000000', '00000001000100000001000000000001', '00100000100000000000000100000100', '00001000001000000000001010000000', '00000010000000010000010000001000', '00010000000010000000100000010000', '00000000000100011000100000000000', '10000000010000000010000000010000', '00000000000000000100010001000100', '00000010000000100000001000000010', '01001000100001000000000000000000', '00010001000000000000000010001000', '00000100000010000001000000100000', '00100000001000000000000100000001', '10001000000000000001000100000000', '00100100000000000000000000011000', '00000011000011000000000000000000', '00010000100000000000010000000010', '00000000010000100000000010000001', '00000000000000001000100001000100', '01000000001000000100000000100000', '00000000000100010010001000000000', '10100000000000000000101000000000', '01010000000010100000000000000000', '00000001000000010001000000010000', '00001010000000001010000000000000', '00000000000101000000000000101000', '00000000101000000000000000000101', '00000000000000000100000110000010', '00000100010000000000010001000000', '00000000001010000001010000000000', '00000100000000010000000100000100', '00000001000000101000000001000000', '00010010000000000000000000100001', '01000000000001000010000000000010', '00001000000100000000100000010000', '10000000010000000100000010000000', '00100000100000000000001000001000', '00000010001000000000100010000000', '00110000000000000011000000000000', '00000001100000000000010000100000', '00000000000110001000000100000000', '00000000000001010000000001010000', '00000000000000000000000000001111', '00000000010000100100001000000000', '10000000000000011000000000000001', '10000100100001000000000000000000', '01001000010010000000000000000000', '00000000000000000010000101001000', '01000001000000000000000000010100', 
            '00100010000000000100010000000000', '00000000001000100000000000100010', '00000100000100000000001010000000', '00011000000000000001100000000000', '01010000000000000000010100000000', '10000000000010000010000000000010', '00001100000000001100000000000000', '00000010000000100001000000010000', '00000000010000010000000000101000', '00100000000100000000100000000100', '00000001100000000000001001000000', '00000000001001000000000010000001', '00000000000000000000001100110000', '00010000000100000100000001000000', '00000000101000001010000000000000', '00000000000000000000110000000011', '00000110000010010000000000000000', '10001000000000000000000010001000', '00000001010000000001000000000100', '01100000000001100000000000000000', '00000001001000000100000000001000', '00010000000000101000000000000100', '00000010010000000000000110000000', '00100000000000010001000000000010', '00000000000000000000011001100000', '01000100100010000000000000000000', '00000000000101000010100000000000', '00000000000000000100100000100001', '00000000000000110000000011000000', '00000010000001000000001000000100', '00100001000000001000010000000000', '00001000000010000000000100000001', '10000000100000000001000000010000', '00001100001100000000000000000000', '01010000000000000000000000001010', '00000000000000000000000010010110', '00000000000001100000100100000000', '00011000100000010000000000000000', '01000000000100000100000000010000', '00000000000000001001000000001001', '00100001010010000000000000000000', '10000000000000010010000000000100', '00000000000000000010001000010001', '00001000000001000000010000001000', '10000000001000000000100000000010', '01000010000000001000000100000000', '00000101000000000000000010100000', '00100000010000000010000001000000', '00000000011000000000011000000000', '00000000100100000000000001100000', '01000000000000010000001010000000', '00000100010000000000000100010000', '10000000000000100100000000000001', '00000001000001000001000001000000', '00000000000000000010010000100100', '10101010000000000000000000000000', '00010100001010000000000000000000', '00000010000100000001000000000010', '00010000000000100100000000001000', '00000000110000000000000000000011', '00000010000010000000001000001000', '00000000001000101000100000000000', '00010001000100010000000000000000', '00000000100001000100100000000000', '00001100000000000011000000000000', '00100000000010000000010000010000', '00000000000000001000000100100100', 
            '01000000000100000000010000000001', '00000000001000010000000001001000', '10000000100000001000000010000000', '00001000000010000100000001000000', '00000100000001000000001000000010', '00000010000000100010000000100000', '10000000010000000000100000000100', '01100000000000000000000010010000', '00010001000000000001000100000000', '10000000000100000000000100001000', '00000001001000000010000000000001', '00000000000001010101000000000000', '00100100000000000000000001000010', '01010000000000000000101000000000', '00000000000010100000000010100000', '00001000010000001000000000000100', '00000010100000000000010000010000', '00010000000001001000000000000010', '00000000000000000000000011001100', '00000000000000000110100100000000', '10000001000110000000000000000000', '00001000000000100000010000000001', '01000000100000000001000000100000', '00000110011000000000000000000000', '00100000000000010000001000010000', '00000000000000001001011000000000', '00010000010000000010000010000000', '01000000000000010000000101000000', '10000100000000000000000000100001', '00000001000001000100000000010000', '00000010000010000000100000000010', '00000000001100000000000000001100', '00000100000000101000000000010000', '00000001000010000000001000000100', '00100000010000000100000000100000', '00001010101000000000000000000000', '00010000000001000000000101000000', '10000000000000100010000000001000', '00000000000000000001010010000010', '01100000100100000000000000000000', '00000100100000000100000000001000', '10010000000000000000011000000000', '00000000010101010000000000000000', '00001001000000000000000010010000', '00000000000000000010100001000001', '00001000000000100000000100000100', '01000000000000011000000000000010', '00100000000010000000100000100000', '00000010001000000001000000000001', '01000000010000000000100000001000', '00000000001001000010010000000000', '00000000100010000001000100000000', '00000000000100100000000000010010', '00000010000000010100000010000000', '10100000000000000000000000000101', '00100100000000000001100000000000', '01010000000000000000000000000101', '00000101000000001010000000000000', '10001000000000000000000000100010', '00001000000100000000001001000000', '00000000000000001100001100000000', '00000000011010010000000000000000', '00000011000000000000000000110000', '00010000000000100000010010000000', '00000000100001000000000001001000', '10000000001000000001000001000000', '00000100000001000000010000000100', 
            '00000000000110000000000010000001', '01101001000000000000000000000000', '00000000000000000010000100010010', '00010000000000010000001000100000', '00000010000000100000100000001000', '00000000110000001100000000000000', '00100000000001001000000000000001', '01000010000000000100001000000000', '00000000000110000010010000000000', '00001100000000110000000000000000', '00010000010000000001000001000000', '00000000101000000000000010100000', '10000001000000000000000000011000', '00000000000000000000100100000110', '00110000001100000000000000000000', '00000001000000100000001000000001', '00000000000000000011000000001100', '01000010000000000000000001000010', '10001000000000000100010000000000', '00000100010000000000100010000000', '00000000100000011000000100000000', '00000000000000000000101001010000', '00000000010001000000000000010001', '00000000001010000000000000101000', '00100000000000100100000000000100', '00000010000001000001000010000000', '00001000100000000010000000000010', '10000000000000010000010000100000', '01010101000000000000000000000000', '00100000010000000000000100001000', '01000000001000001000000000010000', '00000000000110000000000001000010', '00001000000010001000000010000000', '10000100000000000001001000000000', '00000000100100000000100100000000', '00010000000001000100000000000001', '00000011000000110000000000000000', '01000000010000000010000000100000', '00000000000000000000011000000110', '00000001000100001000000000001000', '00000000001000010000000010000100', '00100000000000100000010001000000', '10000010000000000100000100000000', '00001000000001000001000000100000', '00000100100000000010000000000001', '00000000000011000000001100000000', '00000000100000010001100000000000', '00010000001000000010000000010000', '00010010010010000000000000000000', '01000100000000000100010000000000', '00000000000100100000000000100001', '00101000000000000000000000010100', '10000001001001000000000000000000', '00000001100000000100000000000010', '01000000000000100001000000001000', '10100000000000001010000000000000', '00001000010000000000100001000000', '00010000000100001000000010000000', '00000100000010000000010000001000', '00000010000000010000001000000001', '00000000000000000000000011110000', '00000000000000000101000000000101', '00000110100100000000000000000000', '00100000000001000000000110000000', '00000000000000001000100000100010', '10000000000000100000000101000000', '00000000010010000000000000010010', 
            '00000001000000010000100000001000', '01000000001000000000001000000100', '00011000000000000010010000000000', '00110000000000000000000000000011', '11000000000011000000000000000000', '00000000000000000010001010001000', '00000000001100000000110000000000', '00001000010000000000000100100000', '00000000000000000101000001010000', '00000100100000001000000000000100', '00000000101010100000000000000000', '00100010000000000000000001000100', '00000001000000010000000100000001', '01000000000000100000100000010000', '00000000000001010000000000001010', '10000000000100000100000000100000', '00000001010000000000001010000000', '00010010000000001000010000000000', '00000000000000001000001001000001', '00000000100000100000000010000010', '00010100000000000000000000101000', '00000000000101000000000000010100', '00001001000000000110000000000000', '01000100000000000001000100000000', '10000010000000000010100000000000', '00101000001010000000000000000000', '01000000000010000010000000000001', '00000000000000000100100010000100', '00000000000001101001000000000000', '10000000100000000000001000000010', '00001010010100000000000000000000', '00010000000000010000010001000000', '00100000000000010000000100100000', '00000001010000000000010000010000', '00000100001000000001000000001000', '00000000010000100000000000100100', '01000000100000000000010000001000', '00000001001000000000100001000000', '00000000000010011001000000000000', '10010000000000000000000010010000', '00001100000000000000001100000000', '00000010000100000010000000000001', '00000000110000000011000000000000', '00000000000000001000000100011000', '00000000001000100100010000000000', '00000100000000010000100000000010', '00110000000011000000000000000000', '01000001000000000000000010000010', '00000010000001000100000000100000', '10000000000100000000001000000100', '00001001000000000000000000001001', '00100000001000000100000001000000', '00100000010000000000010000000010', '00000000000010100000101000000000', '00001000000001001000000001000000', '00000000100000010000000000100100', '00010000000100000001000000010000', '10000100000000000010000100000000', '01000010000000000000000010000001', '00100001000000000001001000000000', '01001000001000010000000000000000', '00010000100000000000100000000001', '00000110000001100000000000000000', '00000000010100000000000000001010', '10000000000010000100000000000100', '00000000000000001010000010100000', '00000000000000000000010101010000', 
            '00000100000000010100000000010000', '00010001000000000000000000100010', '01000000000000100010000000000100', '00000010100000000000000101000000', '10000000010000000000001000000001', '00100000000100000000010000001000', '00000000001001000001100000000000', '00000010001000000010000000000010', '00000001000001000000010000000001', '00011000000000000100001000000000', '00001100000000000000000011000000', '10000000000010001000000000001000', '00100000000100000001000000100000', '00000000000010010000000010010000', '00000000010000101000000100000000', '01000000100000000000100000000100', '10010000011000000000000000000000', '00000000000000000000000001101001', '00000000100010000010001000000000', '00100010000000001000100000000000', '01000001000000000100000100000000', '00000100000000100000010000000010', '00000000000000001100000000000011', '00010001000000000000000001000100', '00000000010001000000000010001000', '00000000100101100000000000000000', '00001000000100000000000110000000', '11000000000000000000110000000000', '00100100000000000000000000100100', '00001000000010000001000000010000', '00000000001000010001001000000000', '00000000001000100000000000010001', '00000000010000010010100000000000', '00000010000010000000000100000100', '00100000100000000100000000010000', '00000000000000000011000011000000', '01000000000001000000001000100000', '10001000000100010000000000000000', '00000101000000000000000000001010', '00000000001100001100000000000000', '00000000000000001000010010000100', '01011010000000000000000000000000', '00000001000000100001000000100000', '00000000000001010000010100000000', '00110000110000000000000000000000', '10000010000000000000000001000001', '00000100000010000010000000010000', '00000000000000000000101000001010', '00010000001000000000000100000010', '00000010000100000000001000010000', '00000000100010000100010000000000', '00000100010000000001000000000001', '00100000000000100000100010000000', '01001000000000000000000001001000', '00000000000001011010000000000000', '10000001000000000000000000100100', '00000100000100000000100000100000', '00000000000000110000000000001100', '01000000000010000001000000000010', '00000001100000000000000110000000', '00101000000000001000001000000000', '00000000000000000100010000010001', '00000010000001000010000001000000', '00100100001001000000000000000000', '00000001000010000000100000000001', '00000010010000000000010000100000', '10010000000000000110000000000000', 
            '11000000000000110000000000000000', '00000000000000000001000110001000', '00000000011000000000000000000110', '00010000100000001000000000010000', '00000001000100000010000000000010', '00000100000010001000000001000000', '00001000100000000000001000100000', '01000000010000000000000100000001', '00000000000000000101101000000000', '10000000000001000000010010000000', '00110000000000000000000000001100', '00001010000000000000000001010000', '00000000001100110000000000000000', '00000000100000010000000010000001', '00010000000000100000100001000000', '01100000000000000110000000000000', '00000010001000001000000000001000', '10000000000001000001000000000010', '00001000000010000000010000000100', '00000001000100000000000100010000', '00000100010000000000001000100000', '00000010100000000001000000000100', '00000000000000000000000000110011', '10100101000000000000000000000000', '00000000010001001000100000000000', '01000000001000000010000001000000', '00010000000010000000000110000000', '00001000000000100000001000001000', '00001000001000000000100000100000', '00000000000000000100001001000010', '00000000000000000010010000011000', '00100010000100010000000000000000', '00010100000101000000000000000000', '11000000110000000000000000000000', '00000000000000000000010100000101', '00000001000000100100000010000000', '00000000000000000100000100101000', '00010000000000010001000000000001', '00000000001010001000001000000000', '00100000000000100010000000000010', '00000000010000010000000000010100', '01000001000000000001010000000000', '10001000000000001000100000000000', '00000000000011000000000011000000', '01000000000100001000000000100000', '00000110000000000000100100000000', '00000000100100000000011000000000', '00001100000000000000000000000011', '00000000001001000000000000011000', '00010010000000000000000010000100', '10000001100000010000000000000000', '00000000010010000100100000000000', '00010001000000000010001000000000', '00000000000010010000000001100000', '00100000000000100001000000000001', '10100000000000000000010100000000', '01000100000000000000000001000100', '00001000000100000100000000000010', '00000000000000001001000010010000', '00000010100000000010000000001000', '00000000011001100000000000000000', '00000011000000001100000000000000', '00000100001000000000000110000000', '00010000000000100000001000010000', '00000000010100000000000000000101', '00100000000010000010000000001000', '00001000000000010000010000000010', 
            '10000000000001000000100001000000', '01000000000100000010000010000000', '00000000000000001000000101000010', '00000000000000000000110000110000', '00001000100000000001000000000001', '00000101000010100000000000000000', '00100000000000010100000000001000', '00010000000001000001000000000100', '00000010001000000000001000100000', '00000000000000000011001100000000', '00001001011000000000000000000000', '00000000000000001000010000100001', '10000010000000000000000010000010', '00010100010000010000000000000000', '01000000000001000100000000000100', '00100001100001000000000000000000', '00000000000000000010100000010100', '10010000000000000000000000001001', '00100000010000000001000010000000', '00000000101000000000010100000000', '11000000000000000000000000110000', '00001010000010100000000000000000', '00000001000100000000010001000000', '00010000000000100000000100100000', '00000000000110000001100000000000', '00000000010000100000000001000010', '00001000100000000000100010000000', '00000000000010010000000000000110', '00000100000100000100000000000001', '10000000001000000100000000010000', '01100110000000000000000000000000', '01000000000001001000000000001000', '00000000000000001000001000010100', '00000010010000000001000000001000', '00001001000000000000100100000000', '00010000001000000100000010000000', '10000000000000010000001001000000', '00000000100000010010010000000000', '00000000000011000000000000000011', '00100000000100001000000001000000', '01000100000000000010001000000000', '10000000000000100001000000000100', '00000000000100100010000100000000', '01000000001000000000010000000010', '00001010000001010000000000000000', '00100000000010000000001010000000', '00010000100000000100000000100000', '00000000000000000000100100001001', '00000001001000001000000000000100', '00000000100000100000000001000001', '00100010000000000000000000100010', '00000000000000001111000000000000', '00000000110011000000000000000000', '10000100000000000000000001001000', '00001100000000000000000000110000', '01010000010100000000000000000000', '00000000000000000000011010010000', '00000000010000010100000100000000', '00110000000000000000110000000000', '00000001000001000000001000001000', '00000001000000010010000000100000', '00000000100100000000000000000110', '01000000000000101000000000000001', '00000100001000000000100000010000', '00000000000000000001010000101000', '10100000101000000000000000000000', '01000000000001000000000100010000', 
            '10000000000100000001000010000000', '00000001010000001000000000000010', '00000100000000010010000010000000', '00000000000000000100100001001000', '00010000000010000000001001000000', '00001010000000000000000000000101', '10000100000000001000010000000000', '00010010000000000000000000010010', '01000001001010000000000000000000', '00001000000000100001000001000000', '00000000010001000010001000000000', '00000000000110000000000000100100', '00101000000000000100000100000000', '00000010000010000000010000000001', '00010000000000011000000000001000', '00000000000000000000000010101010', '00000000100000100010100000000000', '00000011000000000000001100000000', '00000100010000000100000000000100', '01000000000001000000100010000000', '00000000000100010000000000010001', '10001000001000100000000000000000', '00100000100000000001000001000000', '10000000000010000000000100010000', '00000000000001100000011000000000', '00000000011000000000000001100000', '00000010000100000100000000001000', '00011000000000000000000010000001', '00100000000000011000000000000100', '00000000000000000000001100000011', '00000000010000100000000000011000', '00000000001100000011000000000000', '01000000000000010000100000100000', '01001000000000001000010000000000', '10000001000000000001100000000000', '00010100100000100000000000000000', '00001000000001000010000000010000', '01100000000000000000000000001001', '00000000000000000110000001100000', '00000000010100000000101000000000', '00000010001000000000010001000000', '00000000100001000000000010000100', '00000110000000001001000000000000', '00010000000010000100000000000010', '00100001000000000000000010000100', '00000100000010000000000100000010', '00001100000000000000000000001100', '00000000000000000001001000010010', '00000001000001001000000000100000', '10000010010000010000000000000000', '01000000100000000100000010000000', '00000000001000010010000100000000', '00100001000100100000000000000000', '00000000000101000001010000000000', '00000000010010001000010000000000', '00000101000000000000000001010000', '00000000000000000000101000000101', '00000000101000000000000000001010', '10010000000000000000100100000000', '00000010000010000010000010000000', '01000000000000010100000000000001', '10010000000000000000000001100000', '10000000000000101000000000000010', '00000000110000000000000000110000', '00101000000101000000000000000000', '00100100000000000010010000000000', '00001000001000000100000000000001', 
            '01000000000000100000000110000000', '00010000000010000001000000001000', '00000010000000010000100000000100', '00001000010000000001000000000010', '10000000000001000010000000000001', '00000000001100000000000011000000', '01000000100000001000000001000000', '00000101000000000000101000000000', '00000010000010000100000000010000', '00100000000000100000001000100000', '00010000100000000000000100001000', '00000000000000001000100000010001', '00000000000011110000000000000000', '00000000000000000110000000000110', '00000001001000000000010010000000', '11000011000000000000000000000000', '00000100000100000000000101000000', '00011000000000000000000000100100', '00000000000000000101010100000000', '00000000000000001000001010000010', '10001000100010000000000000000000', '00000001010000000010000000001000', '00100000000000010000100001000000', '01000000010000000000010000000100', '00010010000100100000000000000000', '00100000001000000001000000010000', '00000100000000010000001000001000', '00000000100001000000000000100001', '01000000000010000000000100100000', '00000100000001000100000001000000', '00010000001000000000001000000001', '00001001100100000000000000000000', '00000000000000000000110000001100', '00100000010000001000000000010000', '00000000000000110011000000000000', '00000000000000000010001001000100', '01001000000000000000000000010010', '00000001000001000000100000000010', '00000100000000100100000000100000', '00000000000100010000000010001000', '10000010001010000000000000000000', '00000000000000001000000110000001', '01010000000000001010000000000000', '00000000000110000100001000000000', '10100000000000000000000000001010', '00000000010000010000000001000001', '00110011000000000000000000000000', '00000000100000100001010000000000', '10000000001000000000000100000100', '00000110000000000000000010010000', '00000000110000000000110000000000', '10000000000100001000000000010000', '00100000001000000010000000100000', '01010000000001010000000000000000', '00001010000000000101000000000000', '00000000100010000000000001000100', '00000000000000000001000100100010', '00001000010000000000010010000000', '00000100000001000000100000001000', '00001001000010010000000000000000', '00000010100000000000001010000000', '00010000000000100010000000000001', '00100000000000100000000100010000', '01000001000000000000000001000001', '00000100000100000001000000000100', '00000000001001000100001000000000', '10000000010000000000010000001000', 
            '00000010000001000000010000000010', '00100100100000010000000000000000', '00000000000000000010100010000010', '00000000000000001001000001100000', '00000000000110000000000000011000', '01001000000000000100100000000000', '00010000010000000000000100000100', '10000000001000001000000000100000', '01100000000000000000011000000000', '10000000000010000001000000000001', '00000001000000100010000000010000', '00000000001000100000000010001000', '00011000000000000000000001000010', '00000010100000000000100000100000', '00000001010000000100000000000001', '00000000000101001000001000000000', '00001000100000001000000000001000', '00000100000000010000010000000001', '00000001000001000000000100000100', '10000000000000010100000000000010', '00000010010000000000001001000000', '01000100001000100000000000000000', '00010000000100000010000000100000', '00100000000010000001000000000100', '01000010000000000000000000011000', '00000000000000000000000010100101', '00000000000000001001100100000000', '10001000000000000010001000000000', '00000000100001000000000000010010', '00010001000000000100010000000000', '00100000000010000000000101000000', '00000000001100000000000000000011', '10100000010100000000000000000000', '00000000000000111100000000000000', '00000101101000000000000000000000', '00010000000000010000100010000000', '00000010000000100000010000000100', '01000000010000000001000000010000', '00000100000001000010000000100000', '00001000000010000000100000001000', '00000000000000000000001111000000', '00000000010010000010000100000000', '00010100000000000000000000010100', '00101000000000000000000000101000', '00000000000100100100100000000000', '00000000001000011000010000000000', '00000000100001000001001000000000', '00000011000000000000000000000011', '00100000010000000000100000000001', '00000000000000000010010001000010', '00001000000000010000001000000100', '00000010000001000000000100001000', '10000000100000000100000001000000', '01000000001000000001000010000000', '00000001000010001000000000010000', '10000100000100100000000000000000', '00000000000000001100000000001100', '00000011000000000011000000000000', '00010000000010000000010000100000', '00001000100000000000000100010000', '00000000010100000000000010100000', '11110000000000000000000000000000', '01000000000000100000001001000000', '00000000000000000000000001010101', '00000100000010000000001000000001', '10001000010001000000000000000000', '00000100000001001000000010000000', 
            '00010010001000010000000000000000', '00100000100000000000100000000010', '00000000000100010001000100000000', '01000001000000000000000000101000', '00000000100100000000000000001001', '00000000001010000010100000000000', '00000000000000000110000010010000', '00000000000001100000000000000110', '00010100000000000001010000000000', '01000000010000000000001000000010', '00100000000000010000010010000000', '00001000000000101000000000100000', '01001000000000000010000100000000', '10000000000000010000100000010000', '00010001000000001000100000000000', '00000000000010100000000000001010', '00000010000100000000000100100000', '10000100000000000000000010000100', '00100010010001000000000000000000', '00000000000000000001010001000001', '00000010001000000100000000000100', '00000000000000000000111100000000', '00000100000100001000000000000010', '10000000001000000000001000001000', '00100000000010000100000000000001', '01010000101000000000000000000000', '00000001010000000000000101000000', '00000001100000000010000000000100', '01000010000110000000000000000000', '00000001000000010000001000000010', '00000000000000000000000010011001', '00111100000000000000000000000000', '00001000001000000000010000010000', '00000000000001010000000010100000', '00000000010000100001100000000000', '00000010000000100100000001000000', '01000000000000010001000000000100', '10000000100000000000000100000001', '00000000010100001010000000000000', '10000000000000100000001010000000', '00000001000010000100000000100000', '00000000001001000000000001000010', '00010000000001000010000000001000', '00000000000000001100110000000000', '00000000100110010000000000000000', '00000010100000001000000000000010', '00010000010000000100000000010000', '00000000000000000001001000100001', '00000001000000100000010000001000', '00100000000001000000100000010000', '00001000001000000001000000000100', '00000100100000000000100001000000', '01000100000000000000000000100010', '00001000000000010010000001000000', '00000100000001000000000100000001', '10100000000000000000000010100000', '00000000010010000000000001001000', '00010010000000000001001000000000', '10000001000000000010010000000000', '01001000000100100000000000000000', '00100000001000001000000010000000', '00000000000000000100000100010100'],
}






